/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchDescription;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.semanticweb.owlapi.model.OWLAxiom;

public class IdentifyAxiomAnnotationChanged
extends AbstractAnalyzerAlgorithm {
    public static final MatchDescription AXIOM_ANNOTATION_CHANGED = new MatchDescription("Axiom Annotation Changed");
    private Changes changes;
    private Map<OWLAxiom, OWLAxiom> logicalAxiomToAddedAxiomMap = new HashMap<OWLAxiom, OWLAxiom>();

    public IdentifyAxiomAnnotationChanged() {
        this.setPriority(9);
    }

    @Override
    public void initialise(Engine e) {
        this.changes = e.getChanges();
        for (OWLAxiom axiom : e.getOwlDiffMap().getUnmatchedTargetAxioms()) {
            this.logicalAxiomToAddedAxiomMap.put(axiom.getAxiomWithoutAnnotations(), axiom);
        }
    }

    @Override
    public void apply() {
        for (EntityBasedDiff diff : this.changes.getEntityBasedDiffs()) {
            this.apply(diff);
        }
    }

    public void apply(EntityBasedDiff diff) {
        for (MatchedAxiom removedMatch : new TreeSet<MatchedAxiom>(diff.getAxiomMatches())) {
            MatchedAxiom addedMatch;
            OWLAxiom sourceAxiom;
            OWLAxiom targetAxiom;
            if (!removedMatch.getDescription().equals(MatchedAxiom.AXIOM_DELETED) || (targetAxiom = this.logicalAxiomToAddedAxiomMap.get((sourceAxiom = removedMatch.getSourceAxiom()).getAxiomWithoutAnnotations())) == null || !this.changes.containsMatch(addedMatch = new MatchedAxiom(null, targetAxiom, MatchedAxiom.AXIOM_ADDED))) continue;
            this.changes.removeMatch(removedMatch);
            this.changes.removeMatch(addedMatch);
            this.changes.addMatch(new MatchedAxiom(sourceAxiom, targetAxiom, AXIOM_ANNOTATION_CHANGED));
        }
    }
}

