/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import java.util.HashSet;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;

public class IdentifyAnnotationRefactored
extends AbstractAnalyzerAlgorithm {
    private OWLDataFactory factory;
    private Changes changes;

    public IdentifyAnnotationRefactored() {
        this.setPriority(6);
    }

    @Override
    public void initialise(Engine e) {
        this.factory = e.getOWLDataFactory();
        this.changes = e.getChanges();
    }

    @Override
    public void apply() {
        for (EntityBasedDiff diff : this.changes.getEntityBasedDiffs()) {
            if (diff.getSourceEntity() == null || diff.getTargetEntity() == null) continue;
            this.apply(diff);
        }
    }

    private void apply(EntityBasedDiff diff) {
        HashSet<MatchedAxiom> possibles = new HashSet<MatchedAxiom>();
        for (MatchedAxiom deleted : diff.getAxiomMatches()) {
            if (!this.isCandidate(diff, deleted)) continue;
            possibles.add(deleted);
        }
        for (MatchedAxiom deleted : possibles) {
            OWLEntity targetEntity = diff.getTargetEntity();
            OWLAnnotationAssertionAxiom sourceAxiom = (OWLAnnotationAssertionAxiom)deleted.getSourceAxiom();
            OWLAnnotationAssertionAxiom targetAxiom = this.factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)targetEntity.getIRI(), sourceAxiom.getAnnotation());
            MatchedAxiom added = new MatchedAxiom(null, (OWLAxiom)targetAxiom, MatchedAxiom.AXIOM_ADDED);
            if (!diff.getAxiomMatches().contains(added)) continue;
            this.changes.removeMatch(deleted);
            this.changes.removeMatch(added);
        }
    }

    private boolean isCandidate(EntityBasedDiff diff, MatchedAxiom match) {
        return match.getDescription().equals(MatchedAxiom.AXIOM_DELETED) && match.getSourceAxiom() instanceof OWLAnnotationAssertionAxiom && ((OWLAnnotationAssertionAxiom)match.getSourceAxiom()).getSubject().equals(diff.getSourceEntity().getIRI());
    }
}

