/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present;

import org.protege.owl.diff.present.MatchDescription;
import org.semanticweb.owlapi.model.OWLAxiom;

public class MatchedAxiom
implements Comparable<MatchedAxiom> {
    public static final MatchDescription AXIOM_ADDED = new MatchDescription("Added", 10);
    public static final MatchDescription AXIOM_DELETED = new MatchDescription("Deleted", 10);
    private OWLAxiom sourceAxiom;
    private OWLAxiom targetAxiom;
    private MatchDescription description;
    private boolean isFinal = false;

    public MatchedAxiom(OWLAxiom sourceAxiom, OWLAxiom targetAxiom, MatchDescription description) {
        this.sourceAxiom = sourceAxiom;
        this.targetAxiom = targetAxiom;
        this.description = description;
    }

    public OWLAxiom getSourceAxiom() {
        return this.sourceAxiom;
    }

    public OWLAxiom getTargetAxiom() {
        return this.targetAxiom;
    }

    public MatchDescription getDescription() {
        return this.description;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    @Override
    public int compareTo(MatchedAxiom o) {
        int ret = this.description.compareTo(o.getDescription());
        if (ret != 0) {
            return ret;
        }
        ret = this.compareAxioms(this.sourceAxiom, o.getSourceAxiom());
        if (ret != 0) {
            return ret;
        }
        return this.compareAxioms(this.targetAxiom, o.getTargetAxiom());
    }

    private int compareAxioms(OWLAxiom ax1, OWLAxiom ax2) {
        if (ax1 != null && ax2 != null) {
            return ax1.compareTo((Object)ax2);
        }
        if (ax1 != null && ax2 == null) {
            return 1;
        }
        if (ax1 == null && ax2 != null) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.description.toString() + ": " + this.sourceAxiom + " --> " + this.targetAxiom;
    }
}

