/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present;

import java.util.SortedSet;
import java.util.TreeSet;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.IdentifyRenameOperation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxOWLObjectRendererImpl;

public class EntityBasedDiff
implements Comparable<EntityBasedDiff> {
    private OWLEntity sourceEntity;
    private OWLEntity targetEntity;
    private SortedSet<MatchedAxiom> axiomMatches = new TreeSet<MatchedAxiom>();
    private String diffTypeDescription;

    public OWLEntity getSourceEntity() {
        return this.sourceEntity;
    }

    public void setSourceEntity(OWLEntity sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public OWLEntity getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(OWLEntity targetEntity) {
        this.targetEntity = targetEntity;
    }

    public DiffType getDiffType() {
        if (this.sourceEntity == null) {
            return DiffType.CREATED;
        }
        if (this.targetEntity == null) {
            return DiffType.DELETED;
        }
        if (this.isPureRename()) {
            return DiffType.RENAMED;
        }
        if (!this.sourceEntity.equals(this.targetEntity)) {
            return DiffType.RENAMED_AND_MODIFIED;
        }
        if (!this.axiomMatches.isEmpty()) {
            return DiffType.MODIFIED;
        }
        return DiffType.EQUIVALENT;
    }

    private boolean isPureRename() {
        boolean pureRenameIdentified = this.axiomMatches.size() == 1 && ((MatchedAxiom)this.axiomMatches.iterator().next()).getDescription().equals(IdentifyRenameOperation.RENAMED_CHANGE_DESCRIPTION);
        return !this.sourceEntity.equals(this.targetEntity) && (this.axiomMatches.isEmpty() || pureRenameIdentified);
    }

    public String getDiffTypeDescription() {
        return this.diffTypeDescription == null ? this.getDiffType().getDescription() : this.diffTypeDescription;
    }

    public void setDiffTypeDescription(String diffTypeDescription) {
        this.diffTypeDescription = diffTypeDescription;
    }

    public SortedSet<MatchedAxiom> getAxiomMatches() {
        return this.axiomMatches;
    }

    void addMatch(MatchedAxiom match) {
        this.axiomMatches.add(match);
    }

    void removeMatch(MatchedAxiom match) {
        this.axiomMatches.remove(match);
    }

    public String getShortDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDiffTypeDescription());
        buffer.append(" ");
        switch (this.getDiffType()) {
            case CREATED: {
                buffer.append(this.renderObject((OWLObject)this.targetEntity));
                break;
            }
            case DELETED: {
                buffer.append(this.renderObject((OWLObject)this.sourceEntity));
                break;
            }
            case EQUIVALENT: {
                buffer.append(this.renderObject((OWLObject)this.targetEntity));
                break;
            }
            case RENAMED: {
                buffer.append(this.renderObject((OWLObject)this.sourceEntity));
                buffer.append(" -> ");
                buffer.append(this.renderObject((OWLObject)this.targetEntity));
                break;
            }
            case MODIFIED: 
            case RENAMED_AND_MODIFIED: {
                if (!this.sourceEntity.getIRI().equals(this.targetEntity.getIRI())) {
                    buffer.append("and Renamed ");
                }
                buffer.append(this.renderObject((OWLObject)this.sourceEntity));
                buffer.append(" -> ");
                buffer.append(this.renderObject((OWLObject)this.targetEntity));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Programmer error");
            }
        }
        return buffer.toString();
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer(this.getShortDescription());
        buffer.append("\n------------------------------------------------------\n");
        for (MatchedAxiom match : this.axiomMatches) {
            buffer.append(match.getDescription().getDescription());
            buffer.append(": ");
            if (match.getSourceAxiom() == null) {
                buffer.append("\t");
                buffer.append(this.renderObject((OWLObject)match.getTargetAxiom()));
            } else if (match.getTargetAxiom() == null) {
                buffer.append("\t");
                buffer.append(this.renderObject((OWLObject)match.getSourceAxiom()));
            } else {
                buffer.append("\t");
                buffer.append(this.renderObject((OWLObject)match.getSourceAxiom()));
                buffer.append("\n\t\t-->\n\t");
                buffer.append(this.renderObject((OWLObject)match.getTargetAxiom()));
            }
            buffer.append('\n');
        }
        if (!this.axiomMatches.isEmpty()) {
            buffer.append("------------------------------------------------------\n");
        }
        return buffer.toString();
    }

    protected String renderObject(OWLObject o) {
        if (o instanceof OWLAnnotationAssertionAxiom && ((OWLAnnotationAssertionAxiom)o).getSubject() instanceof IRI) {
            SimpleIRIShortFormProvider iriShortFormProvider = new SimpleIRIShortFormProvider();
            OWLAnnotationAssertionAxiom axiom = (OWLAnnotationAssertionAxiom)o;
            StringBuffer buffer = new StringBuffer(iriShortFormProvider.getShortForm((IRI)axiom.getSubject()));
            buffer.append(" ");
            buffer.append(new ManchesterOWLSyntaxOWLObjectRendererImpl().render((OWLObject)axiom.getAnnotation()));
            return buffer.toString();
        }
        return new ManchesterOWLSyntaxOWLObjectRendererImpl().render(o);
    }

    @Override
    public int compareTo(EntityBasedDiff o) {
        int ret;
        if (this.sourceEntity == null && o.sourceEntity == null && this.targetEntity == null && o.targetEntity == null) {
            return 0;
        }
        if (this.sourceEntity != null && o.sourceEntity == null) {
            return 1;
        }
        if (this.sourceEntity == null && o.sourceEntity != null) {
            return -1;
        }
        if (this.targetEntity != null && o.targetEntity == null) {
            return 1;
        }
        if (this.targetEntity == null && o.targetEntity != null) {
            return -1;
        }
        if (this.sourceEntity != null && (ret = this.sourceEntity.compareTo((Object)o.sourceEntity)) != 0) {
            return ret;
        }
        if (this.targetEntity != null) {
            return this.targetEntity.compareTo((Object)o.targetEntity);
        }
        return 0;
    }

    public String toString() {
        return "[Diff: " + this.getShortDescription() + "]";
    }

    public static enum DiffType {
        EQUIVALENT("Unchanged"),
        CREATED("Created"),
        DELETED("Deleted"),
        RENAMED("Renamed"),
        RENAMED_AND_MODIFIED("Renamed and Modified"),
        MODIFIED("Modified");

        private String description;

        private DiffType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

