/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.present.AxiomDescribesEntitiesDetector;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.util.GetAxiomSourceVisitor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

public class Changes {
    private Collection<OWLAxiom> unmatchedSourceAxiomsWithNoSubject = new HashSet<OWLAxiom>();
    private Collection<OWLAxiom> unmatchedTargetAxiomsWithNoSubject = new HashSet<OWLAxiom>();
    private SortedSet<EntityBasedDiff> entityBasedDiffs = new TreeSet<EntityBasedDiff>();
    private Map<OWLEntity, EntityBasedDiff> sourceDiffMap = new HashMap<OWLEntity, EntityBasedDiff>();
    private Map<OWLEntity, EntityBasedDiff> targetDiffMap = new HashMap<OWLEntity, EntityBasedDiff>();
    private AxiomDescribesEntitiesDetector sourceEntitiesDetector;
    private AxiomDescribesEntitiesDetector targetEntitiesDetector;
    private OwlDiffMap diffMap;

    public Changes(OwlDiffMap diffMap) {
        this.diffMap = diffMap;
        this.sourceEntitiesDetector = new GetAxiomSourceVisitor(diffMap.getSourceOntology(), diffMap.getOWLDataFactory());
        this.targetEntitiesDetector = new GetAxiomSourceVisitor(diffMap.getTargetOntology(), diffMap.getOWLDataFactory());
        this.initialiseDiffs();
    }

    public SortedSet<EntityBasedDiff> getEntityBasedDiffs() {
        return this.entityBasedDiffs;
    }

    public Map<OWLEntity, EntityBasedDiff> getSourceDiffMap() {
        return this.sourceDiffMap;
    }

    public Map<OWLEntity, EntityBasedDiff> getTargetDiffMap() {
        return this.targetDiffMap;
    }

    public OwlDiffMap getRawDiffMap() {
        return this.diffMap;
    }

    public Collection<OWLAxiom> getUnmatchedSourceAxiomsWithNoSubject() {
        return this.unmatchedSourceAxiomsWithNoSubject;
    }

    public Collection<OWLAxiom> getUnmatchedTargetAxiomsWithNoSubject() {
        return this.unmatchedTargetAxiomsWithNoSubject;
    }

    public boolean containsMatch(MatchedAxiom match) {
        Collection<OWLEntity> subjects;
        if (match.getSourceAxiom() != null && !(subjects = this.sourceEntitiesDetector.getSources(match.getSourceAxiom())).isEmpty()) {
            OWLEntity entity = subjects.iterator().next();
            EntityBasedDiff entityDiff = this.sourceDiffMap.get(entity);
            return entityDiff != null && entityDiff.getAxiomMatches().contains(match);
        }
        if (match.getTargetAxiom() != null && !(subjects = this.sourceEntitiesDetector.getSources(match.getTargetAxiom())).isEmpty()) {
            OWLEntity entity = subjects.iterator().next();
            EntityBasedDiff entityDiff = this.targetDiffMap.get(entity);
            return entityDiff != null && entityDiff.getAxiomMatches().contains(match);
        }
        return match.getDescription().equals(MatchedAxiom.AXIOM_DELETED) && this.unmatchedSourceAxiomsWithNoSubject.contains(match.getSourceAxiom()) || match.getDescription().equals(MatchedAxiom.AXIOM_ADDED) && this.unmatchedTargetAxiomsWithNoSubject.contains(match.getTargetAxiom());
    }

    public void addMatch(MatchedAxiom match) {
        EntityBasedDiff diff;
        Collection<OWLEntity> subjects;
        OWLAxiom axiom;
        if (match.getSourceAxiom() != null) {
            axiom = match.getSourceAxiom();
            subjects = this.sourceEntitiesDetector.getSources(axiom);
            for (OWLEntity e : subjects) {
                diff = this.sourceDiffMap.get(e);
                if (diff == null) {
                    diff = new EntityBasedDiff();
                    diff.setSourceEntity(e);
                    diff.setTargetEntity(e);
                    this.sourceDiffMap.put(e, diff);
                    this.targetDiffMap.put(e, diff);
                    this.entityBasedDiffs.add(diff);
                }
                diff.addMatch(match);
            }
            if (subjects.isEmpty()) {
                this.unmatchedSourceAxiomsWithNoSubject.add(axiom);
            }
        }
        if (match.getTargetAxiom() != null) {
            axiom = match.getTargetAxiom();
            subjects = this.targetEntitiesDetector.getSources(axiom);
            for (OWLEntity e : subjects) {
                diff = this.targetDiffMap.get(e);
                if (diff == null) {
                    diff = new EntityBasedDiff();
                    diff.setSourceEntity(e);
                    diff.setTargetEntity(e);
                    this.sourceDiffMap.put(e, diff);
                    this.targetDiffMap.put(e, diff);
                    this.entityBasedDiffs.add(diff);
                }
                diff.addMatch(match);
            }
            if (subjects.isEmpty()) {
                this.unmatchedTargetAxiomsWithNoSubject.add(axiom);
            }
        }
    }

    public void removeMatch(MatchedAxiom match) {
        EntityBasedDiff diff;
        Collection<OWLEntity> subjects;
        OWLAxiom axiom;
        if (match.getSourceAxiom() != null) {
            axiom = match.getSourceAxiom();
            subjects = this.sourceEntitiesDetector.getSources(axiom);
            for (OWLEntity e : subjects) {
                diff = this.sourceDiffMap.get(e);
                if (diff == null) continue;
                diff.removeMatch(match);
            }
            if (subjects.isEmpty()) {
                this.unmatchedSourceAxiomsWithNoSubject.remove(axiom);
            }
        }
        if (match.getTargetAxiom() != null) {
            axiom = match.getTargetAxiom();
            subjects = this.targetEntitiesDetector.getSources(axiom);
            for (OWLEntity e : subjects) {
                diff = this.targetDiffMap.get(e);
                if (diff == null) continue;
                diff.removeMatch(match);
            }
            if (subjects.isEmpty()) {
                this.unmatchedTargetAxiomsWithNoSubject.remove(axiom);
            }
        }
    }

    private void initialiseDiffs() {
        EntityBasedDiff d;
        for (OWLEntity oWLEntity : this.diffMap.getUnmatchedSourceEntities()) {
            d = new EntityBasedDiff();
            d.setSourceEntity(oWLEntity);
            this.sourceDiffMap.put(oWLEntity, d);
            this.entityBasedDiffs.add(d);
        }
        for (Map.Entry entry : this.diffMap.getEntityMap().entrySet()) {
            OWLEntity target;
            OWLEntity source = (OWLEntity)entry.getKey();
            if (source.equals(target = (OWLEntity)entry.getValue())) continue;
            EntityBasedDiff d2 = new EntityBasedDiff();
            d2.setSourceEntity(source);
            d2.setTargetEntity(target);
            this.sourceDiffMap.put(source, d2);
            this.targetDiffMap.put(target, d2);
            this.entityBasedDiffs.add(d2);
        }
        for (OWLEntity oWLEntity : this.diffMap.getUnmatchedTargetEntities()) {
            d = new EntityBasedDiff();
            d.setTargetEntity(oWLEntity);
            this.targetDiffMap.put(oWLEntity, d);
            this.entityBasedDiffs.add(d);
        }
        for (OWLAxiom oWLAxiom : this.diffMap.getUnmatchedSourceAxioms()) {
            this.addMatch(new MatchedAxiom(oWLAxiom, null, MatchedAxiom.AXIOM_DELETED));
        }
        for (OWLAxiom oWLAxiom : this.diffMap.getUnmatchedTargetAxioms()) {
            this.addMatch(new MatchedAxiom(null, oWLAxiom, MatchedAxiom.AXIOM_ADDED));
        }
    }
}

