/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.util;

public class CompareNames {
    private static final char[] DELIMITERS = new char[]{'_', '-', ' ', '(', ')', '.'};
    private static double THRESHOLD = 0.95;
    private static int TOO_SMALL = 3;
    private static int TYPO_LENGTH = 2;

    public static boolean closeEnough(String str1, String str2) {
        String s2;
        if (str1.equals(str2)) {
            return true;
        }
        String s1 = CompareNames.convertString(str1);
        boolean result = CompareNames.compare(s1, s2 = CompareNames.convertString(str2));
        if (!result) {
            result = CompareNames.compare(s2, s1);
        }
        return result;
    }

    private static String convertString(String str) {
        String result = str.toLowerCase();
        for (int i = 0; i < DELIMITERS.length; ++i) {
            result = CompareNames.removeCharacter(result, DELIMITERS[i]);
        }
        return result;
    }

    private static String removeCharacter(String s, char c) {
        int searchIndex;
        String result = new String();
        int currentIndex = 0;
        do {
            if ((searchIndex = s.indexOf(c, currentIndex)) != -1) {
                result = result.concat(s.substring(currentIndex, searchIndex));
                currentIndex = searchIndex + 1;
                continue;
            }
            result = result.concat(s.substring(currentIndex));
        } while (searchIndex != -1);
        return result;
    }

    private static boolean compare(String s1, String s2) {
        int b;
        int f;
        int endIndex = (int)Math.round((double)s1.length() * THRESHOLD);
        if (endIndex < 0 && endIndex < s1.length()) {
            return false;
        }
        String part1 = s1.substring(0, endIndex);
        if (part1.length() <= TOO_SMALL) {
            return false;
        }
        if (s2.indexOf(part1) != -1 && (double)((float)s1.length() / (float)s2.length()) > THRESHOLD) {
            return true;
        }
        if (Math.abs(s1.length() - s2.length()) > TOO_SMALL) {
            return false;
        }
        for (f = 0; f < s1.length() && f < s2.length() && s1.charAt(f) == s2.charAt(f); ++f) {
        }
        if (f == s1.length() || f == s2.length()) {
            return false;
        }
        for (b = 1; b < s1.length() && b < s2.length() && s1.charAt(s1.length() - b) == s2.charAt(s2.length() - b); ++b) {
        }
        return Math.abs(s1.length() - b - f) < TYPO_LENGTH;
    }
}

