/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.UnmatchedSourceAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.util.OWLEntityCollector;

public class UnmatchedSourceAxiomImpl
implements UnmatchedSourceAxiom {
    private Set<OWLEntity> referencedUnmatchedEntities;
    private Collection<OWLAnonymousIndividual> referencedUnmatchedAnonymousIndividuals;
    private OWLAxiom axiom;

    public UnmatchedSourceAxiomImpl(OWLAxiom axiom) {
        this.axiom = axiom;
        this.referencedUnmatchedEntities = new HashSet<OWLEntity>();
        this.referencedUnmatchedAnonymousIndividuals = new HashSet<OWLAnonymousIndividual>();
        OWLEntityCollector collector = new OWLEntityCollector(this.referencedUnmatchedEntities, this.referencedUnmatchedAnonymousIndividuals);
        axiom.accept((OWLObjectVisitor)collector);
    }

    @Override
    public Collection<OWLEntity> getReferencedUnmatchedEntities() {
        return Collections.unmodifiableCollection(this.referencedUnmatchedEntities);
    }

    @Override
    public Collection<OWLAnonymousIndividual> getReferencedUnmatchedAnonymousIndividuals() {
        return Collections.unmodifiableCollection(this.referencedUnmatchedAnonymousIndividuals);
    }

    @Override
    public OWLAxiom getAxiom() {
        return this.axiom;
    }

    @Override
    public void trim(OwlDiffMap diffMap) {
        Iterator<OWLEntity> referencedIt = this.referencedUnmatchedEntities.iterator();
        while (referencedIt.hasNext()) {
            OWLEntity referencedEntity = referencedIt.next();
            if (diffMap.getUnmatchedSourceEntities().contains(referencedEntity)) continue;
            referencedIt.remove();
        }
        Iterator<OWLAnonymousIndividual> referencedIndIt = this.referencedUnmatchedAnonymousIndividuals.iterator();
        while (referencedIndIt.hasNext()) {
            OWLAnonymousIndividual referencedIndividual = referencedIndIt.next();
            if (diffMap.getUnmatchedSourceAnonymousIndividuals().contains(referencedIndividual)) continue;
            referencedIndIt.remove();
        }
    }

    public String toString() {
        return "{unref = " + this.referencedUnmatchedEntities.size() + " - " + this.axiom + "}";
    }
}

