/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.impl;

import java.util.Map;
import org.apache.log4j.Logger;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.AlignmentListener;
import org.protege.owl.diff.align.impl.OwlDiffMapCore;
import org.protege.owl.diff.align.util.AlignmentListenerAdapter;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public class OwlDiffMapImpl
extends OwlDiffMapCore {
    private Logger logger = Logger.getLogger(OwlDiffMapImpl.class);
    private static final String SEPARATOR_STRING = " **************** ";
    private OWLDataFactory factory;
    private OWLOntology sourceOntology;
    private OWLOntology targetOntology;
    private int matchedEntitiesSinceAnnounce = 0;
    private int matchedAxiomsSinceAnnounce = 0;
    private AlignmentAlgorithm lastAnnouncedDiffAlgorithm;
    private long lastAnnounceTime = -1L;
    private AlignmentListener trackingListener = new AlignmentListenerAdapter(){

        @Override
        public void addMatch(OWLEntity source, OWLEntity target) {
            OwlDiffMapImpl.this.matchedEntitiesSinceAnnounce++;
        }

        @Override
        public void addMatchingEntities(Map<OWLEntity, OWLEntity> newMatches) {
            OwlDiffMapImpl.this.matchedEntitiesSinceAnnounce += newMatches.size();
        }

        @Override
        public void addMatchedAxiom(OWLAxiom axiom) {
            OwlDiffMapImpl.this.matchedAxiomsSinceAnnounce++;
        }
    };

    public OwlDiffMapImpl(OWLDataFactory factory, OWLOntology sourceOntology, OWLOntology targetOntology) {
        super(factory, sourceOntology, targetOntology);
        this.factory = factory;
        this.sourceOntology = sourceOntology;
        this.targetOntology = targetOntology;
        this.addDiffListener(this.trackingListener);
    }

    @Override
    public OWLDataFactory getOWLDataFactory() {
        return this.factory;
    }

    @Override
    public OWLOntology getSourceOntology() {
        return this.sourceOntology;
    }

    @Override
    public OWLOntology getTargetOntology() {
        return this.targetOntology;
    }

    @Override
    public void announce(AlignmentAlgorithm da) {
        this.logger.info((Object)(SEPARATOR_STRING + da.getAlgorithmName() + SEPARATOR_STRING));
        this.lastAnnouncedDiffAlgorithm = da;
        this.lastAnnounceTime = System.currentTimeMillis();
        this.matchedAxiomsSinceAnnounce = 0;
        this.matchedEntitiesSinceAnnounce = 0;
    }

    @Override
    public void summarize() {
        long took = System.currentTimeMillis() - this.lastAnnounceTime;
        this.logger.info((Object)("Algorithm " + this.lastAnnouncedDiffAlgorithm.getAlgorithmName() + " completed."));
        this.logger.info((Object)(this.lastAnnouncedDiffAlgorithm.getAlgorithmName() + " step took " + took + " ms."));
        if (this.matchedEntitiesSinceAnnounce == 0) {
            this.logger.info((Object)"No progress made.");
        } else {
            this.logger.info((Object)("" + this.matchedEntitiesSinceAnnounce + " owl entities matched up."));
            this.logger.info((Object)("" + this.matchedAxiomsSinceAnnounce + " axioms matched up."));
        }
        this.logger.info((Object)SEPARATOR_STRING);
    }
}

