/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.UnmatchedSourceAxiom;
import org.protege.owl.diff.align.impl.DiffListenerCollection;
import org.protege.owl.diff.align.impl.UnmatchedSourceAxiomImpl;
import org.protege.owl.diff.util.DiffDuplicator;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public abstract class OwlDiffMapCore
extends DiffListenerCollection
implements OwlDiffMap {
    public static final Logger LOGGER = Logger.getLogger(OwlDiffMapCore.class);
    private Map<OWLEntity, OWLEntity> entityMap = new HashMap<OWLEntity, OWLEntity>();
    private Set<OWLEntity> unmatchedSourceEntities = new HashSet<OWLEntity>();
    private Set<OWLEntity> unmatchedTargetEntities;
    private Map<OWLEntity, Set<OWLEntity>> blockedEntityMatches = new HashMap<OWLEntity, Set<OWLEntity>>();
    private Map<OWLAnonymousIndividual, OWLAnonymousIndividual> anonymousIndividualMap = new HashMap<OWLAnonymousIndividual, OWLAnonymousIndividual>();
    private Set<OWLAnonymousIndividual> unmatchedSourceAnonIndividuals = new HashSet<OWLAnonymousIndividual>();
    private Set<OWLAnonymousIndividual> unmatchedTargetAnonIndividuals;
    private Map<OWLObject, AlignmentExplanation> explanationMap = new HashMap<OWLObject, AlignmentExplanation>();
    private Map<OWLObject, Set<UnmatchedSourceAxiom>> unmatchedSourceAxiomMap = new HashMap<OWLObject, Set<UnmatchedSourceAxiom>>();
    private Set<UnmatchedSourceAxiom> potentialMatchingSourceAxioms = new HashSet<UnmatchedSourceAxiom>();
    private Set<OWLAxiom> unmatchedSourceAxioms;
    private Set<OWLAxiom> unmatchedTargetAxioms;
    private Set<UnmatchedSourceAxiom> completedAnnnotationAssertionAxioms = new HashSet<UnmatchedSourceAxiom>();

    protected OwlDiffMapCore(OWLDataFactory factory, OWLOntology sourceOntology, OWLOntology targetOntology) {
        long startTime = System.currentTimeMillis();
        this.unmatchedSourceAxioms = new HashSet<OWLAxiom>(sourceOntology.getAxioms());
        this.unmatchedTargetAxioms = new HashSet<OWLAxiom>(targetOntology.getAxioms());
        for (OWLAxiom axiom : this.unmatchedSourceAxioms) {
            Set<UnmatchedSourceAxiom> unmatchedSet;
            UnmatchedSourceAxiomImpl unmatched = new UnmatchedSourceAxiomImpl(axiom);
            this.potentialMatchingSourceAxioms.add(unmatched);
            for (OWLEntity entity : unmatched.getReferencedUnmatchedEntities()) {
                unmatchedSet = this.unmatchedSourceAxiomMap.get(entity);
                if (unmatchedSet == null) {
                    unmatchedSet = new HashSet<UnmatchedSourceAxiom>();
                    this.unmatchedSourceAxiomMap.put((OWLObject)entity, unmatchedSet);
                }
                unmatchedSet.add(unmatched);
            }
            for (OWLAnonymousIndividual anonymous : unmatched.getReferencedUnmatchedAnonymousIndividuals()) {
                unmatchedSet = this.unmatchedSourceAxiomMap.get(anonymous);
                if (unmatchedSet == null) {
                    unmatchedSet = new HashSet<UnmatchedSourceAxiom>();
                    this.unmatchedSourceAxiomMap.put((OWLObject)anonymous, unmatchedSet);
                }
                unmatchedSet.add(unmatched);
            }
            this.unmatchedSourceEntities.addAll(unmatched.getReferencedUnmatchedEntities());
            this.unmatchedSourceAnonIndividuals.addAll(unmatched.getReferencedUnmatchedAnonymousIndividuals());
        }
        this.unmatchedTargetEntities = new HashSet<OWLEntity>(targetOntology.getSignature());
        this.unmatchedTargetAnonIndividuals = new HashSet<OWLAnonymousIndividual>(targetOntology.getReferencedAnonymousIndividuals());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Initialization of core diff map structures took " + (System.currentTimeMillis() - startTime) + "ms."));
        }
    }

    @Override
    public Map<OWLEntity, OWLEntity> getEntityMap() {
        return Collections.unmodifiableMap(this.entityMap);
    }

    @Override
    public AlignmentExplanation getExplanation(OWLEntity sourceEntity) {
        return this.explanationMap.get(sourceEntity);
    }

    @Override
    public Map<OWLAnonymousIndividual, OWLAnonymousIndividual> getAnonymousIndividualMap() {
        return Collections.unmodifiableMap(this.anonymousIndividualMap);
    }

    @Override
    public AlignmentExplanation getExplanation(OWLAnonymousIndividual sourceIndividual) {
        return this.explanationMap.get(sourceIndividual);
    }

    @Override
    public Set<OWLEntity> getUnmatchedSourceEntities() {
        return Collections.unmodifiableSet(this.unmatchedSourceEntities);
    }

    @Override
    public Set<OWLEntity> getUnmatchedTargetEntities() {
        return Collections.unmodifiableSet(this.unmatchedTargetEntities);
    }

    @Override
    public Set<OWLAnonymousIndividual> getUnmatchedSourceAnonymousIndividuals() {
        return Collections.unmodifiableSet(this.unmatchedSourceAnonIndividuals);
    }

    @Override
    public Set<OWLAnonymousIndividual> getUnmatchedTargetAnonymousIndividuals() {
        return Collections.unmodifiableSet(this.unmatchedTargetAnonIndividuals);
    }

    @Override
    public Set<UnmatchedSourceAxiom> getPotentialMatchingSourceAxioms() {
        return Collections.unmodifiableSet(this.potentialMatchingSourceAxioms);
    }

    @Override
    public Set<OWLAxiom> getUnmatchedSourceAxioms() {
        return Collections.unmodifiableSet(this.unmatchedSourceAxioms);
    }

    @Override
    public Set<OWLAxiom> getUnmatchedTargetAxioms() {
        return Collections.unmodifiableSet(this.unmatchedTargetAxioms);
    }

    @Override
    public void addMatchingEntities(Map<OWLEntity, OWLEntity> newMatches, AlignmentExplanation explanation) {
        this.clearBadMatches(newMatches);
        this.unmatchedSourceEntities.removeAll(newMatches.keySet());
        this.unmatchedTargetEntities.removeAll(newMatches.values());
        this.entityMap.putAll(newMatches);
        HashSet<UnmatchedSourceAxiom> movingSourceAxioms = new HashSet<UnmatchedSourceAxiom>();
        for (OWLEntity newEntity : newMatches.keySet()) {
            Set<UnmatchedSourceAxiom> removedUnmatchedSourceAxioms = this.unmatchedSourceAxiomMap.remove(newEntity);
            if (removedUnmatchedSourceAxioms != null) {
                movingSourceAxioms.addAll(removedUnmatchedSourceAxioms);
            }
            this.explanationMap.put((OWLObject)newEntity, explanation);
        }
        this.updateAxiomMatches(movingSourceAxioms);
        this.fireAddMatchingEntities(newMatches);
    }

    @Override
    public void addMatch(OWLEntity source, OWLEntity target, AlignmentExplanation explanation) {
        if (!this.goodMatch(source, target)) {
            return;
        }
        this.unmatchedSourceEntities.remove(source);
        this.unmatchedTargetEntities.remove(target);
        this.entityMap.put(source, target);
        this.explanationMap.put((OWLObject)source, explanation);
        this.updateAxiomMatches(this.unmatchedSourceAxiomMap.remove(source));
        this.fireAddMatch(source, target);
    }

    @Override
    public void setMatchBlocked(OWLEntity source, OWLEntity target, boolean block) {
        Set<OWLEntity> blockedTargets = this.blockedEntityMatches.get(source);
        if (block) {
            if (blockedTargets == null) {
                blockedTargets = new TreeSet<OWLEntity>();
                this.blockedEntityMatches.put(source, blockedTargets);
            }
            blockedTargets.add(target);
        } else if (blockedTargets != null) {
            blockedTargets.remove(target);
        }
    }

    @Override
    public void addMatchingAnonymousIndividuals(Map<OWLAnonymousIndividual, OWLAnonymousIndividual> newMatches, AlignmentExplanation explanation) {
        this.clearBadMatchesForAnonIndividuals(newMatches);
        this.unmatchedSourceAnonIndividuals.removeAll(newMatches.keySet());
        this.unmatchedTargetAnonIndividuals.removeAll(newMatches.values());
        this.anonymousIndividualMap.putAll(newMatches);
        HashSet<UnmatchedSourceAxiom> movingSourceAxioms = new HashSet<UnmatchedSourceAxiom>();
        for (OWLAnonymousIndividual newMatchingIndividual : newMatches.keySet()) {
            Set<UnmatchedSourceAxiom> removedUnmatchedSourceAxioms = this.unmatchedSourceAxiomMap.remove(newMatchingIndividual);
            if (removedUnmatchedSourceAxioms != null) {
                movingSourceAxioms.addAll(removedUnmatchedSourceAxioms);
            }
            this.explanationMap.put((OWLObject)newMatchingIndividual, explanation);
        }
        this.updateAxiomMatches(movingSourceAxioms);
        this.fireAddMatchingAnonymousIndividuals(newMatches);
    }

    @Override
    public void addMatch(OWLAnonymousIndividual source, OWLAnonymousIndividual target, AlignmentExplanation explanation) {
        if (!this.goodMatch(source, target)) {
            return;
        }
        this.unmatchedSourceAnonIndividuals.remove(source);
        this.unmatchedTargetAnonIndividuals.remove(target);
        this.anonymousIndividualMap.put(source, target);
        this.explanationMap.put((OWLObject)source, explanation);
        this.updateAxiomMatches(this.unmatchedSourceAxiomMap.remove(source));
        this.fireAddMatch(source, target);
    }

    @Override
    public void finish() {
        for (UnmatchedSourceAxiom unmatched : this.completedAnnnotationAssertionAxioms) {
            this.updateAxiomMatches(unmatched, true);
        }
    }

    @Override
    public boolean processingDone() {
        return this.unmatchedSourceAxiomMap.isEmpty();
    }

    private void clearBadMatches(Map<OWLEntity, OWLEntity> newMatches) {
        TreeSet<OWLEntity> sourceEntriesToRemove = new TreeSet<OWLEntity>();
        for (Map.Entry<OWLEntity, OWLEntity> entry : newMatches.entrySet()) {
            OWLEntity target;
            OWLEntity source = entry.getKey();
            if (this.goodMatch(source, target = entry.getValue())) continue;
            sourceEntriesToRemove.add(source);
        }
        for (OWLEntity source : sourceEntriesToRemove) {
            newMatches.remove(source);
        }
    }

    private boolean goodMatch(OWLEntity source, OWLEntity target) {
        Set<OWLEntity> blockedTargets = this.blockedEntityMatches.get(source);
        boolean notBlocked = blockedTargets == null || !blockedTargets.contains(target);
        boolean notMatched = this.unmatchedSourceEntities.contains(source) && this.unmatchedTargetEntities.contains(target);
        return notBlocked && notMatched;
    }

    private void clearBadMatchesForAnonIndividuals(Map<OWLAnonymousIndividual, OWLAnonymousIndividual> newMatches) {
        TreeSet<OWLAnonymousIndividual> sourceEntriesToRemove = new TreeSet<OWLAnonymousIndividual>();
        for (Map.Entry<OWLAnonymousIndividual, OWLAnonymousIndividual> entry : newMatches.entrySet()) {
            OWLAnonymousIndividual target;
            OWLAnonymousIndividual source = entry.getKey();
            if (this.goodMatch(source, target = entry.getValue())) continue;
            sourceEntriesToRemove.add(source);
        }
        for (OWLAnonymousIndividual source : sourceEntriesToRemove) {
            newMatches.remove(source);
        }
    }

    private boolean goodMatch(OWLAnonymousIndividual source, OWLAnonymousIndividual target) {
        return this.unmatchedSourceAnonIndividuals.contains(source) && this.unmatchedTargetAnonIndividuals.contains(target);
    }

    private void updateAxiomMatches(Set<UnmatchedSourceAxiom> unmatchedAxioms) {
        if (unmatchedAxioms != null) {
            for (UnmatchedSourceAxiom unmatched : unmatchedAxioms) {
                this.updateAxiomMatches(unmatched, false);
            }
        }
    }

    private void updateAxiomMatches(UnmatchedSourceAxiom unmatched, boolean cleanup) {
        unmatched.trim(this);
        if (unmatched.getReferencedUnmatchedEntities().isEmpty() && unmatched.getReferencedUnmatchedAnonymousIndividuals().isEmpty()) {
            this.potentialMatchingSourceAxioms.remove(unmatched);
            DiffDuplicator duplicator = new DiffDuplicator(this);
            OWLAxiom potentialTargetAxiom = (OWLAxiom)duplicator.duplicateObject((OWLObject)unmatched.getAxiom());
            if (this.unmatchedTargetAxioms.contains(potentialTargetAxiom)) {
                this.unmatchedSourceAxioms.remove(unmatched.getAxiom());
                this.unmatchedTargetAxioms.remove(potentialTargetAxiom);
                this.fireAddMatchedAxiom(potentialTargetAxiom);
            } else if (!cleanup && unmatched.getAxiom() instanceof OWLAnnotationAssertionAxiom) {
                this.completedAnnnotationAssertionAxioms.add(unmatched);
            } else {
                this.fireAddUnmatcheableAxiom(potentialTargetAxiom);
            }
        }
        this.fireUnmatchedAxiomMoved(unmatched);
    }
}

