/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.protege.owl.diff.align.AlignmentListener;
import org.protege.owl.diff.align.UnmatchedSourceAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

public class DiffListenerCollection {
    private List<AlignmentListener> listeners = new ArrayList<AlignmentListener>();

    public void addDiffListener(AlignmentListener listener) {
        this.listeners.add(listener);
    }

    public void removeDiffListener(AlignmentListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireAddMatchingEntities(Map<OWLEntity, OWLEntity> newMatches) {
        for (AlignmentListener listener : this.listeners) {
            listener.addMatchingEntities(newMatches);
        }
    }

    protected void fireAddMatchingAnonymousIndividuals(Map<OWLAnonymousIndividual, OWLAnonymousIndividual> newMatches) {
        for (AlignmentListener listener : this.listeners) {
            listener.addMatchingAnonymousIndividuals(newMatches);
        }
    }

    protected void fireAddMatch(OWLEntity source, OWLEntity target) {
        for (AlignmentListener listener : this.listeners) {
            listener.addMatch(source, target);
        }
    }

    protected void fireAddMatch(OWLAnonymousIndividual source, OWLAnonymousIndividual target) {
        for (AlignmentListener listener : this.listeners) {
            listener.addMatch(source, target);
        }
    }

    protected void fireUnmatchedAxiomMoved(UnmatchedSourceAxiom unmatched) {
        for (AlignmentListener listener : this.listeners) {
            listener.unmatchedAxiomMoved(unmatched);
        }
    }

    protected void fireAddUnmatcheableAxiom(OWLAxiom axiom) {
        for (AlignmentListener listener : this.listeners) {
            listener.addUnmatcheableAxiom(axiom);
        }
    }

    protected void fireAddMatchedAxiom(OWLAxiom axiom) {
        for (AlignmentListener listener : this.listeners) {
            listener.addMatchedAxiom(axiom);
        }
    }
}

