/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAggressiveness;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.AlignmentListener;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.UnmatchedSourceAxiom;
import org.protege.owl.diff.align.impl.SimpleAlignmentExplanation;
import org.protege.owl.diff.align.util.AlignmentListenerAdapter;
import org.protege.owl.diff.service.RenderingService;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class SuperSubClassPinch
implements AlignmentAlgorithm {
    public static final String REQUIRED_SUBCLASSES_PROPERTY = "diff.pinch.required.subclasses";
    private static Logger log = Logger.getLogger(SuperSubClassPinch.class);
    private OwlDiffMap diffMap;
    private RenderingService renderer;
    private boolean disabled = false;
    private boolean firstPass = true;
    private int requiredSubclasses;
    private Map<OWLClass, Set<OWLClass>> superClassOf = new HashMap<OWLClass, Set<OWLClass>>();
    private Map<OWLClass, Set<OWLClass>> subClassOf = new HashMap<OWLClass, Set<OWLClass>>();
    private Map<OWLEntity, OWLEntity> newMatches = new HashMap<OWLEntity, OWLEntity>();
    private AlignmentListener listener = new AlignmentListenerAdapter(){

        @Override
        public void unmatchedAxiomMoved(UnmatchedSourceAxiom unmatched) {
            SuperSubClassPinch.this.addCandidateUnmatchedAxiom(unmatched);
        }

        @Override
        public void addMatch(OWLEntity source, OWLEntity target) {
            SuperSubClassPinch.this.superClassOf.remove(source);
            SuperSubClassPinch.this.subClassOf.remove(source);
        }

        @Override
        public void addMatchingEntities(Map<OWLEntity, OWLEntity> newMatches) {
            for (OWLEntity source : newMatches.keySet()) {
                SuperSubClassPinch.this.superClassOf.remove(source);
                SuperSubClassPinch.this.subClassOf.remove(source);
            }
        }
    };

    @Override
    public String getAlgorithmName() {
        return "Super-Sub class pinch algorithm";
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public AlignmentAggressiveness getAggressiveness() {
        return AlignmentAggressiveness.MODERATE;
    }

    @Override
    public void initialise(Engine e) {
        this.diffMap = e.getOwlDiffMap();
        this.renderer = RenderingService.get(e);
        this.requiredSubclasses = 1;
        if (e.getParameters().get(REQUIRED_SUBCLASSES_PROPERTY) != null) {
            try {
                this.requiredSubclasses = Integer.parseInt(e.getParameters().get(REQUIRED_SUBCLASSES_PROPERTY));
            }
            catch (NumberFormatException t) {
                log.warn((Object)"Could not initialize required subclasses value", (Throwable)t);
                this.disabled = true;
            }
        }
    }

    @Override
    public void reset() {
        this.superClassOf.clear();
        this.subClassOf.clear();
        this.diffMap.removeDiffListener(this.listener);
        this.diffMap = null;
        this.renderer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.disabled) {
            return;
        }
        this.diffMap.announce(this);
        try {
            this.newMatches.clear();
            if (this.firstPass) {
                this.diffMap.addDiffListener(this.listener);
                this.firstPass = false;
                this.findCandidateUnmatchedAxioms();
            }
            this.searchForMatches();
            this.diffMap.addMatchingEntities(this.newMatches, new Explanation(this.diffMap, this.renderer));
        }
        finally {
            this.diffMap.summarize();
        }
    }

    private void findCandidateUnmatchedAxioms() {
        this.subClassOf.clear();
        this.superClassOf.clear();
        for (UnmatchedSourceAxiom unmatched : this.diffMap.getPotentialMatchingSourceAxioms()) {
            this.addCandidateUnmatchedAxiom(unmatched);
        }
    }

    private void addCandidateUnmatchedAxiom(UnmatchedSourceAxiom unmatched) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Examining  axiom " + unmatched));
        }
        if (!this.isCandidiateUnmatchedAxiom(unmatched)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"no good");
            }
            return;
        }
        OWLSubClassOfAxiom subClassOfAxiom = (OWLSubClassOfAxiom)unmatched.getAxiom();
        OWLClass subClass = subClassOfAxiom.getSubClass().asOWLClass();
        OWLClass superClass = subClassOfAxiom.getSuperClass().asOWLClass();
        if (this.diffMap.getUnmatchedSourceEntities().contains(subClass)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("found super class of " + subClass));
            }
            SuperSubClassPinch.addToMap(this.superClassOf, subClass, superClass);
        }
        if (this.diffMap.getUnmatchedSourceEntities().contains(superClass)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("found sub class of " + superClass));
            }
            SuperSubClassPinch.addToMap(this.subClassOf, superClass, subClass);
        }
    }

    private boolean isCandidiateUnmatchedAxiom(UnmatchedSourceAxiom unmatched) {
        if (unmatched.getAxiom() instanceof OWLSubClassOfAxiom && !((OWLSubClassOfAxiom)unmatched.getAxiom()).getSubClass().isAnonymous() && !((OWLSubClassOfAxiom)unmatched.getAxiom()).getSuperClass().isAnonymous()) {
            unmatched.trim(this.diffMap);
            return unmatched.getReferencedUnmatchedEntities().size() == 1;
        }
        return false;
    }

    public static <X, Y> void addToMap(Map<X, Set<Y>> map, X x, Y y) {
        Set<Y> ys = map.get(x);
        if (ys == null) {
            ys = new HashSet<Y>();
            map.put(x, ys);
        }
        ys.add(y);
    }

    private void searchForMatches() {
        for (OWLClass sourceClass : this.superClassOf.keySet()) {
            this.searchForMatches(sourceClass, this.getTargetMappedClasses(sourceClass, this.superClassOf), this.getTargetMappedClasses(sourceClass, this.subClassOf));
        }
    }

    private Set<OWLClass> getTargetMappedClasses(OWLClass sourceClass, Map<OWLClass, Set<OWLClass>> map) {
        HashSet<OWLClass> mappedTargetClasses = new HashSet<OWLClass>();
        Set<OWLClass> mappedSourceClasses = map.get(sourceClass);
        if (mappedSourceClasses != null) {
            for (OWLClass mappedSourceClass : mappedSourceClasses) {
                OWLClass targetClass = (OWLClass)this.diffMap.getEntityMap().get(mappedSourceClass);
                if (targetClass == null) continue;
                mappedTargetClasses.add(targetClass);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("" + sourceClass + " subclasses map to " + mappedTargetClasses));
        }
        return mappedTargetClasses;
    }

    private void searchForMatches(OWLClass sourceClass, Set<OWLClass> possibleTargetSuperclasses, Set<OWLClass> possibleTargetSubclasses) {
        for (OWLClass possibleTargetSuperClass : possibleTargetSuperclasses) {
            for (OWLClassExpression possibleTargetClass : possibleTargetSuperClass.getSubClasses(this.diffMap.getTargetOntology())) {
                if (possibleTargetClass.isAnonymous() || !this.searchForMatches(sourceClass, possibleTargetClass.asOWLClass(), possibleTargetSubclasses)) continue;
                return;
            }
        }
    }

    private boolean searchForMatches(OWLClass sourceClass, OWLClass potentialMatchingClass, Set<OWLClass> desiredTargetSubClasses) {
        int count = 0;
        for (OWLClassExpression targetSubclass : potentialMatchingClass.getSubClasses(this.diffMap.getTargetOntology())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\t" + targetSubclass));
            }
            if (desiredTargetSubClasses.contains(targetSubclass)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\tgood subclass");
                }
                if (++count < this.requiredSubclasses) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"match added");
                }
                this.newMatches.put((OWLEntity)sourceClass, (OWLEntity)potentialMatchingClass);
                return true;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)"\tbad subclass");
        }
        return false;
    }

    private static class Explanation
    extends SimpleAlignmentExplanation {
        private OwlDiffMap diffs;
        private RenderingService renderer;

        public Explanation(OwlDiffMap diffs, RenderingService renderer) {
            super("Aligned source and target entities that have a matching parent and child.");
            this.diffs = diffs;
            this.renderer = renderer;
        }

        @Override
        public boolean hasDetailedExplanation(OWLObject sourceObject) {
            return sourceObject instanceof OWLClass;
        }

        @Override
        public String getDetailedExplanation(OWLObject sourceObject) {
            OWLClass source = (OWLClass)sourceObject;
            OWLClass target = (OWLClass)this.diffs.getEntityMap().get(source);
            StringBuffer sb = new StringBuffer();
            sb.append(this.getExplanation());
            sb.append("\n\t");
            sb.append(this.renderer.renderSourceObject((OWLObject)source));
            sb.append("  -->   ");
            sb.append(this.renderer.renderTargetObject((OWLObject)target));
            sb.append("\n");
            this.addMatchingParents(source, target, sb);
            this.addMatchingChildren(source, target, sb);
            return sb.toString();
        }

        private void addMatchingParents(OWLClass source, OWLClass target, StringBuffer sb) {
            Set targetParents = target.getSuperClasses(this.diffs.getTargetOntology());
            for (OWLClassExpression sourceParent : source.getSuperClasses(this.diffs.getSourceOntology())) {
                OWLClass targetParent = (OWLClass)this.diffs.getEntityMap().get(sourceParent);
                if (targetParent == null || !targetParents.contains(targetParent)) continue;
                sb.append("Source entity has parent\n\t");
                sb.append(this.renderer.renderSourceObject((OWLObject)((OWLClass)sourceParent)));
                sb.append("\nwhich maps to the following parent of the target entity\n\t");
                sb.append(this.renderer.renderTargetObject((OWLObject)targetParent));
                sb.append('\n');
            }
        }

        private void addMatchingChildren(OWLClass source, OWLClass target, StringBuffer sb) {
            Set targetChildren = target.getSubClasses(this.diffs.getTargetOntology());
            for (OWLClassExpression sourceChild : source.getSubClasses(this.diffs.getSourceOntology())) {
                OWLClass targetChild = (OWLClass)this.diffs.getEntityMap().get(sourceChild);
                if (targetChild == null || !targetChildren.contains(targetChild)) continue;
                sb.append("Source entity has child\n\t");
                sb.append(this.renderer.renderSourceObject((OWLObject)((OWLClass)sourceChild)));
                sb.append("\nwhich maps to the following child of the target entity\n\t");
                sb.append(this.renderer.renderTargetObject((OWLObject)targetChild));
                sb.append('\n');
            }
        }
    }
}

