/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAggressiveness;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.impl.SimpleAlignmentExplanation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class MatchStandardVocabulary
implements AlignmentAlgorithm {
    public static final AlignmentExplanation EXPLANATION = new SimpleAlignmentExplanation("Aligned common standard vocabulary elements.");
    private static final Set<IRI> STANDARD_OWL_IRIS = new HashSet<IRI>();
    private boolean alreadyRun = false;
    private OwlDiffMap diffs;

    @Override
    public String getAlgorithmName() {
        return "Match Standard OWL Terms";
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public AlignmentAggressiveness getAggressiveness() {
        return AlignmentAggressiveness.IGNORE_REFACTOR;
    }

    @Override
    public void initialise(Engine e) {
        this.diffs = e.getOwlDiffMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.alreadyRun) {
            try {
                this.diffs.announce(this);
                HashMap<OWLEntity, OWLEntity> matches = new HashMap<OWLEntity, OWLEntity>();
                for (OWLEntity entity : this.diffs.getUnmatchedSourceEntities()) {
                    if (!STANDARD_OWL_IRIS.contains(entity.getIRI())) continue;
                    matches.put(entity, entity);
                }
                this.diffs.addMatchingEntities(matches, EXPLANATION);
            }
            finally {
                this.diffs.summarize();
            }
            this.alreadyRun = true;
        }
    }

    @Override
    public void reset() {
        this.alreadyRun = false;
    }

    static {
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLRDFVocabulary.values()) {
            STANDARD_OWL_IRIS.add(oWLRDFVocabulary.getIRI());
        }
        for (OWLRDFVocabulary oWLRDFVocabulary : OWL2Datatype.values()) {
            STANDARD_OWL_IRIS.add(oWLRDFVocabulary.getIRI());
        }
    }
}

