/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.HashMap;
import java.util.Map;
import org.protege.owl.diff.DifferencePosition;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAggressiveness;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.algorithms.AbstractApproximateSiblingMatch;
import org.protege.owl.diff.align.impl.SimpleAlignmentExplanation;
import org.protege.owl.diff.service.RenderingService;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class MatchSiblingsWithSimilarBrowserText
extends AbstractApproximateSiblingMatch {
    private RenderingService renderer;
    private Explain explanation;

    @Override
    public void initialise(Engine e) {
        super.initialise(e);
        this.renderer = RenderingService.get(e);
        this.explanation = new Explain(e);
    }

    @Override
    public String getBrowserText(OWLClass cls, DifferencePosition position) {
        switch (position) {
            case SOURCE: {
                return this.renderer.renderSourceObject((OWLObject)cls);
            }
            case TARGET: {
                return this.renderer.renderTargetObject((OWLObject)cls);
            }
        }
        throw new IllegalStateException("Shouldn't get here");
    }

    @Override
    public String getAlgorithmName() {
        return "Match Siblings with approximately similar renderings";
    }

    @Override
    protected AlignmentExplanation getExplanation() {
        return this.explanation;
    }

    @Override
    public AlignmentAggressiveness getAggressiveness() {
        return AlignmentAggressiveness.MODERATE;
    }

    @Override
    protected boolean checkMatch(Map<OWLEntity, OWLEntity> newMatches, OWLClass sourceParent, OWLClass unmatchedSourceSibling, OWLClass targetParent, OWLClass unmatchedTargetSibling) {
        if (super.checkMatch(newMatches, sourceParent, unmatchedSourceSibling, targetParent, unmatchedTargetSibling)) {
            this.explanation.addSourceChildToParentMapping(unmatchedSourceSibling, sourceParent);
            return true;
        }
        return false;
    }

    private static class Explain
    extends SimpleAlignmentExplanation {
        private OwlDiffMap diffMap;
        private RenderingService renderer;
        private Map<OWLClass, OWLClass> sourceSiblingToParentMap = new HashMap<OWLClass, OWLClass>();

        public Explain(Engine e) {
            super("Entities matched up because their parents matched and they have similar renderings.");
            this.diffMap = e.getOwlDiffMap();
            this.renderer = RenderingService.get(e);
        }

        @Override
        public boolean hasDetailedExplanation(OWLObject sourceObject) {
            return this.sourceSiblingToParentMap.containsKey(sourceObject);
        }

        @Override
        public String getDetailedExplanation(OWLObject sourceObject) {
            OWLClass targetObject = (OWLClass)this.diffMap.getEntityMap().get(sourceObject);
            OWLClass sourceParent = this.sourceSiblingToParentMap.get(sourceObject);
            OWLClass targetParent = (OWLClass)this.diffMap.getEntityMap().get(sourceParent);
            StringBuffer sb = new StringBuffer();
            sb.append("I matched the source class, \n\t");
            sb.append(this.renderer.renderSourceObject(sourceObject));
            sb.append(",\nwith the target class\n\t");
            sb.append(this.renderer.renderTargetObject((OWLObject)targetObject));
            sb.append(",\nbecause I judged their renderings to be similar and because the parent of the\n");
            sb.append("source class,\n\t");
            sb.append(this.renderer.renderSourceObject((OWLObject)sourceParent));
            sb.append(",\nmapped to a parent,\n\t");
            sb.append(this.renderer.renderTargetObject((OWLObject)targetParent));
            sb.append(",\nof the target object.");
            return sb.toString();
        }

        public void addSourceChildToParentMapping(OWLClass child, OWLClass parent) {
            this.sourceSiblingToParentMap.put(child, parent);
        }
    }
}

