/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.protege.owl.diff.DifferencePosition;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAggressiveness;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.algorithms.AbstractSiblingMatch;
import org.protege.owl.diff.align.impl.SimpleAlignmentExplanation;
import org.protege.owl.diff.service.RenderingService;
import org.protege.owl.diff.service.SiblingService;
import org.protege.owl.diff.util.EntityComparator;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class MatchLoneSiblings
extends AbstractSiblingMatch {
    @Override
    public void initialise(Engine e) {
        super.initialise(e);
    }

    @Override
    protected void checkSiblings(OWLClass sourceParent, Set<OWLClass> unmatchedSourceSiblings, OWLClass targetParent, Set<OWLClass> unmatchedTargetSiblings) {
        if (unmatchedSourceSiblings.size() == 1 && unmatchedTargetSiblings.size() == 1) {
            OWLClass sourceSibling = unmatchedSourceSiblings.iterator().next();
            OWLClass targetSibling = unmatchedTargetSiblings.iterator().next();
            this.getOwlDiffMap().addMatch((OWLEntity)sourceSibling, (OWLEntity)targetSibling, (AlignmentExplanation)new Explanation(this.getEngine(), sourceSibling, sourceParent));
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public AlignmentAggressiveness getAggressiveness() {
        return AlignmentAggressiveness.AGGRESSIVE_SEARCH;
    }

    @Override
    public String getAlgorithmName() {
        return "Match Lone Siblings";
    }

    private static class Explanation
    extends SimpleAlignmentExplanation {
        private OWLClass sourceClass;
        private OWLClass sourceParent;
        private OwlDiffMap diffMap;
        private Map<OWLClass, OWLClass> targetToSourceMap;
        private RenderingService renderer;
        private SiblingService siblingService;

        public Explanation(Engine engine, OWLClass sourceClass, OWLClass sourceParent) {
            super("Aligned the lone unmatched siblings.");
            this.diffMap = engine.getOwlDiffMap();
            this.renderer = RenderingService.get(engine);
            this.siblingService = SiblingService.get(engine);
            this.sourceClass = sourceClass;
            this.sourceParent = sourceParent;
        }

        @Override
        public boolean hasDetailedExplanation(OWLObject sourceObject) {
            return sourceObject.equals(this.sourceClass);
        }

        @Override
        public String getDetailedExplanation(OWLObject sourceObject) {
            OWLClass targetClass = (OWLClass)this.diffMap.getEntityMap().get(this.sourceClass);
            OWLClass targetParent = (OWLClass)this.diffMap.getEntityMap().get(this.sourceParent);
            StringBuffer sb = new StringBuffer();
            this.addMainExplanation(sb, this.sourceClass, targetParent, targetClass);
            this.addSourceChildrenExplanation(sb, this.diffMap, this.sourceParent, (OWLClass)sourceObject);
            this.addTargetChildrenExplanation(sb, this.diffMap, targetParent, targetClass);
            return sb.toString();
        }

        private void addMainExplanation(StringBuffer sb, OWLClass sourceObject, OWLClass targetParent, OWLClass targetClass) {
            sb.append("I matched the source class, \n\t");
            sb.append(this.renderer.renderSourceObject((OWLObject)sourceObject));
            sb.append(",\nwith the target class\n\t");
            sb.append(this.renderer.renderTargetObject((OWLObject)targetClass));
            sb.append(",\nbecause the source class is the only unmatched child of\n\t");
            sb.append(this.renderer.renderSourceObject((OWLObject)this.sourceParent));
            sb.append(",\nbecause the target class is the only unmatched child of\n\t");
            sb.append(this.renderer.renderTargetObject((OWLObject)targetParent));
            sb.append(",\nand the two parents match.\n");
        }

        private void addSourceChildrenExplanation(StringBuffer sb, OwlDiffMap diffMap, OWLClass sourceParent, OWLClass sourceObject) {
            ArrayList<OWLClass> sourceSubclasses = new ArrayList<OWLClass>();
            for (OWLClass sourceSubclass : this.siblingService.getSubClasses(sourceParent, DifferencePosition.SOURCE)) {
                if (sourceSubclass.isAnonymous()) continue;
                sourceSubclasses.add(sourceSubclass.asOWLClass());
            }
            sourceSubclasses.remove(sourceObject);
            if (sourceSubclasses.isEmpty()) {
                sb.append("The source parent has no other subclasses\n\n");
            } else {
                Collections.sort(sourceSubclasses, new EntityComparator(this.renderer, DifferencePosition.SOURCE));
                sb.append("The other children of the source parent map as follows:\n");
                for (OWLClass sourceSubclass : sourceSubclasses) {
                    sb.append("\t");
                    sb.append(this.renderer.renderSourceObject((OWLObject)sourceSubclass.asOWLClass()));
                    sb.append(" --> ");
                    sb.append(this.renderer.renderTargetObject((OWLObject)((OWLClass)diffMap.getEntityMap().get(sourceSubclass))));
                    sb.append('\n');
                }
            }
        }

        private void addTargetChildrenExplanation(StringBuffer sb, OwlDiffMap diffMap, OWLClass targetParent, OWLClass targetClass) {
            ArrayList<OWLClass> targetSubclasses = new ArrayList<OWLClass>();
            for (OWLClass targetSubclass : this.siblingService.getSubClasses(targetParent, DifferencePosition.TARGET)) {
                if (targetSubclass.isAnonymous()) continue;
                targetSubclasses.add(targetSubclass.asOWLClass());
            }
            targetSubclasses.remove(targetClass);
            if (targetSubclasses.isEmpty()) {
                sb.append("The target parent has no other subclasses.\n\n");
            } else {
                Collections.sort(targetSubclasses, new EntityComparator(this.renderer, DifferencePosition.TARGET));
                sb.append("The other children of the target parent map as follows:\n");
                for (OWLClass targetSubclass : targetSubclasses) {
                    OWLClass sourceSubclass = this.getMatchingSourceClass(targetSubclass);
                    sb.append("\t");
                    sb.append(this.renderer.renderSourceObject((OWLObject)sourceSubclass));
                    sb.append(" --> ");
                    sb.append(this.renderer.renderTargetObject((OWLObject)targetSubclass));
                    sb.append('\n');
                }
            }
        }

        private OWLClass getMatchingSourceClass(OWLClass targetClass) {
            if (this.targetToSourceMap == null) {
                this.targetToSourceMap = new HashMap<OWLClass, OWLClass>();
                for (Map.Entry<OWLEntity, OWLEntity> entry : this.diffMap.getEntityMap().entrySet()) {
                    OWLEntity source = entry.getKey();
                    OWLEntity target = entry.getValue();
                    if (!(source instanceof OWLClass)) continue;
                    this.targetToSourceMap.put((OWLClass)target, (OWLClass)source);
                }
            }
            return this.targetToSourceMap.get(targetClass);
        }
    }
}

