/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAggressiveness;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.impl.SimpleAlignmentExplanation;
import org.protege.owl.diff.service.RenderingService;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class MatchByRendering
implements AlignmentAlgorithm {
    public static final AlignmentExplanation EXPLANATION = new SimpleAlignmentExplanation("Enties with a common rendering are matched.");
    private Logger logger = Logger.getLogger(MatchByRendering.class);
    private boolean disabled = false;
    private OwlDiffMap diffMap;
    private RenderingService renderer;

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public int getPriority() {
        return 9;
    }

    @Override
    public AlignmentAggressiveness getAggressiveness() {
        return AlignmentAggressiveness.MODERATE;
    }

    @Override
    public void initialise(Engine e) {
        this.diffMap = e.getOwlDiffMap();
        this.renderer = RenderingService.get(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.disabled) {
            this.diffMap.announce(this);
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Matching source entities with target entities");
                }
                this.matchEntities();
            }
            finally {
                this.diffMap.summarize();
            }
        }
        this.disabled = true;
    }

    @Override
    public void reset() {
        this.disabled = false;
    }

    private boolean matchEntities() {
        HashMap<OWLEntity, OWLEntity> matchMap = new HashMap<OWLEntity, OWLEntity>();
        for (OWLEntity sourceEntity : this.diffMap.getUnmatchedSourceEntities()) {
            OWLEntity potentialTargetEntity;
            String rendering = this.renderer.renderSourceObject((OWLObject)sourceEntity);
            if (rendering == null || (potentialTargetEntity = this.renderer.getTargetEntityByRendering(rendering)) == null || !this.isMatch(sourceEntity, potentialTargetEntity)) continue;
            matchMap.put(sourceEntity, potentialTargetEntity);
        }
        if (matchMap.isEmpty()) {
            return false;
        }
        this.diffMap.addMatchingEntities(matchMap, EXPLANATION);
        return true;
    }

    private boolean isMatch(OWLEntity entity1, OWLEntity entity2) {
        return entity1.getEntityType() == entity2.getEntityType();
    }

    @Override
    public String getAlgorithmName() {
        return "Match By Rendering";
    }
}

