/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAggressiveness;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.impl.SimpleAlignmentExplanation;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class MatchByIdFragment
implements AlignmentAlgorithm {
    public static final AlignmentExplanation EXPLANATION = new SimpleAlignmentExplanation("Aligned source and target entities because they have a common IRI fragment.");
    private ShortFormProvider shortFormProvider;
    private OwlDiffMap diffs;
    private boolean alreadyRun = false;

    @Override
    public void initialise(Engine e) {
        this.shortFormProvider = new SimpleShortFormProvider();
        this.diffs = e.getOwlDiffMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.alreadyRun) {
            return;
        }
        this.diffs.announce(this);
        try {
            Map<String, Collection<OWLEntity>> map = this.collectTargetEntitiesByShortForm();
            this.searchForMatches(map);
        }
        finally {
            this.diffs.summarize();
            this.alreadyRun = true;
        }
    }

    private Map<String, Collection<OWLEntity>> collectTargetEntitiesByShortForm() {
        HashMap<String, Collection<OWLEntity>> map = new HashMap<String, Collection<OWLEntity>>();
        for (OWLEntity targetEntity : this.diffs.getUnmatchedTargetEntities()) {
            String shortForm = this.shortFormProvider.getShortForm(targetEntity);
            ArrayList<OWLEntity> entities = (ArrayList<OWLEntity>)map.get(shortForm);
            if (entities == null) {
                entities = new ArrayList<OWLEntity>();
                map.put(shortForm, entities);
            }
            entities.add(targetEntity);
        }
        return map;
    }

    private void searchForMatches(Map<String, Collection<OWLEntity>> targetEntitiesByShortForm) {
        for (OWLEntity sourceEntity : new ArrayList<OWLEntity>(this.diffs.getUnmatchedSourceEntities())) {
            OWLEntity matchingTarget;
            String shortForm = this.shortFormProvider.getShortForm(sourceEntity);
            Collection<OWLEntity> targetEntities = targetEntitiesByShortForm.get(shortForm);
            if (targetEntities == null || (matchingTarget = this.findMatch(sourceEntity, targetEntities)) == null || sourceEntity.getIRI().equals(matchingTarget.getIRI())) continue;
            this.diffs.addMatch(sourceEntity, matchingTarget, EXPLANATION);
        }
    }

    private OWLEntity findMatch(OWLEntity sourceEntity, Collection<OWLEntity> targetEntities) {
        OWLEntity match = null;
        EntityType matchingType = sourceEntity.getEntityType();
        for (OWLEntity potentialMatch : targetEntities) {
            EntityType targetType = potentialMatch.getEntityType();
            if (targetType == matchingType && match == null) {
                match = potentialMatch;
                continue;
            }
            if (targetType != matchingType) continue;
            return null;
        }
        return match;
    }

    @Override
    public void reset() {
        this.alreadyRun = false;
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public AlignmentAggressiveness getAggressiveness() {
        return AlignmentAggressiveness.CONSERVATIVE;
    }

    @Override
    public String getAlgorithmName() {
        return "Match Entities by IRI fragment";
    }
}

