/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.HashMap;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAggressiveness;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.impl.SimpleAlignmentExplanation;
import org.protege.owl.diff.service.DeprecationDeferralService;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public class MatchById
implements AlignmentAlgorithm {
    public static final AlignmentExplanation EXPLANATION = new SimpleAlignmentExplanation("Source and targe entities aligned because they have the same IRI.");
    private boolean disabled = false;
    private OwlDiffMap diffMap;
    private DeprecationDeferralService dds;

    @Override
    public String getAlgorithmName() {
        return "Match By Id";
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public AlignmentAggressiveness getAggressiveness() {
        return AlignmentAggressiveness.IGNORE_REFACTOR;
    }

    @Override
    public void initialise(Engine e) {
        this.diffMap = e.getOwlDiffMap();
        this.dds = DeprecationDeferralService.get(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.disabled) {
            this.diffMap.announce(this);
            try {
                HashMap<OWLEntity, OWLEntity> matchingMap = new HashMap<OWLEntity, OWLEntity>();
                OWLOntology targetOntology = this.diffMap.getTargetOntology();
                for (OWLEntity unmatchedSourceEntity : this.diffMap.getUnmatchedSourceEntities()) {
                    boolean found = targetOntology.containsEntityInSignature(unmatchedSourceEntity);
                    if (!found) continue;
                    if (this.dds.checkDeprecation(unmatchedSourceEntity, unmatchedSourceEntity)) {
                        this.dds.addMatch(unmatchedSourceEntity, unmatchedSourceEntity, EXPLANATION);
                        continue;
                    }
                    matchingMap.put(unmatchedSourceEntity, unmatchedSourceEntity);
                }
                this.diffMap.addMatchingEntities(matchingMap, EXPLANATION);
            }
            finally {
                this.diffMap.summarize();
            }
        }
        this.disabled = true;
    }

    @Override
    public void reset() {
        this.disabled = false;
    }
}

