/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAggressiveness;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.impl.SimpleAlignmentExplanation;
import org.protege.owl.diff.service.CodeToEntityMapper;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;

public class MatchByCode
implements AlignmentAlgorithm {
    public static final AlignmentExplanation EXPLANATION = new SimpleAlignmentExplanation("Enties with a common code value are matched.");
    private Logger logger = Logger.getLogger(MatchByCode.class);
    private boolean disabled = false;
    private OwlDiffMap diffMap;
    private CodeToEntityMapper codeMapper;

    @Override
    public int getPriority() {
        return 9;
    }

    @Override
    public AlignmentAggressiveness getAggressiveness() {
        return AlignmentAggressiveness.IGNORE_REFACTOR;
    }

    @Override
    public void initialise(Engine e) {
        this.diffMap = e.getOwlDiffMap();
        this.codeMapper = CodeToEntityMapper.get(e);
        if (this.codeMapper.codeNotPresent()) {
            this.disabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.disabled) {
            this.diffMap.announce(this);
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Matching source entities with target entities");
                }
                this.matchEntities();
            }
            finally {
                this.diffMap.summarize();
            }
        }
        this.disabled = true;
    }

    @Override
    public void reset() {
        this.disabled = false;
    }

    private boolean matchEntities() {
        HashMap<OWLEntity, OWLEntity> matchMap = new HashMap<OWLEntity, OWLEntity>();
        OWLOntology sourceOntology = this.diffMap.getSourceOntology();
        for (OWLEntity sourceEntity : sourceOntology.getSignature()) {
            Collection<OWLEntity> targetEntities;
            String code = this.codeMapper.getCode(sourceOntology, sourceEntity);
            if (code == null || (targetEntities = this.codeMapper.getTargetEntities(code)) == null) continue;
            OWLEntity matchedTargetEntity = null;
            for (OWLEntity potentialTargetEntity : targetEntities) {
                if (!this.isMatch(sourceEntity, potentialTargetEntity)) continue;
                matchedTargetEntity = potentialTargetEntity;
            }
            if (matchedTargetEntity == null) continue;
            matchMap.put(sourceEntity, matchedTargetEntity);
        }
        if (matchMap.isEmpty()) {
            return false;
        }
        this.diffMap.addMatchingEntities(matchMap, EXPLANATION);
        return true;
    }

    private boolean isMatch(OWLEntity entity1, final OWLEntity entity2) {
        return (Boolean)entity1.accept((OWLEntityVisitorEx)new OWLEntityVisitorEx<Boolean>(){

            public Boolean visit(OWLClass cls) {
                return entity2.isOWLClass();
            }

            public Boolean visit(OWLObjectProperty property) {
                return entity2.isOWLObjectProperty();
            }

            public Boolean visit(OWLDataProperty property) {
                return entity2.isOWLDataProperty();
            }

            public Boolean visit(OWLNamedIndividual individual) {
                return entity2.isOWLNamedIndividual();
            }

            public Boolean visit(OWLDatatype datatype) {
                return entity2.isOWLDatatype();
            }

            public Boolean visit(OWLAnnotationProperty property) {
                return entity2.isOWLAnnotationProperty();
            }
        });
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public String getAlgorithmName() {
        return "Match By Code";
    }
}

