/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.Map;
import org.apache.log4j.Logger;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAggressiveness;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.AlignmentListener;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.UnmatchedSourceAxiom;
import org.protege.owl.diff.service.DeprecationDeferralService;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

public class DeferDeprecationAlgorithm
implements AlignmentAlgorithm {
    public static final Logger LOGGER = Logger.getLogger(DeferDeprecationAlgorithm.class);
    private OwlDiffMap diffMap;
    private DeprecationDeferralService dds;
    private boolean progress;
    private AlignmentListener listener = new AlignmentListener(){

        @Override
        public void unmatchedAxiomMoved(UnmatchedSourceAxiom unmatched) {
        }

        @Override
        public void addUnmatcheableAxiom(OWLAxiom axiom) {
        }

        @Override
        public void addMatchingEntities(Map<OWLEntity, OWLEntity> newMatches) {
            if (!newMatches.isEmpty()) {
                DeferDeprecationAlgorithm.this.progress = true;
            }
        }

        @Override
        public void addMatchingAnonymousIndividuals(Map<OWLAnonymousIndividual, OWLAnonymousIndividual> newMatches) {
            if (!newMatches.isEmpty()) {
                DeferDeprecationAlgorithm.this.progress = true;
            }
        }

        @Override
        public void addMatchedAxiom(OWLAxiom axiom) {
        }

        @Override
        public void addMatch(OWLAnonymousIndividual source, OWLAnonymousIndividual target) {
            DeferDeprecationAlgorithm.this.progress = true;
        }

        @Override
        public void addMatch(OWLEntity source, OWLEntity target) {
            DeferDeprecationAlgorithm.this.progress = true;
        }
    };

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void initialise(Engine e) {
        this.dds = DeprecationDeferralService.get(e);
        this.diffMap = e.getOwlDiffMap();
        this.progress = false;
        this.diffMap.addDiffListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.progress) {
            this.diffMap.announce(this);
            try {
                this.matchEntities();
            }
            finally {
                this.diffMap.summarize();
            }
        }
        this.progress = false;
    }

    private void matchEntities() {
        for (DeprecationDeferralService.DeferredMatchBean bean : this.dds.getDeferredMatches()) {
            OWLEntity sourceEntity = bean.getSourceEntity();
            OWLEntity targetEntity = bean.getTargetEntity();
            this.diffMap.setMatchBlocked(sourceEntity, targetEntity, false);
            if (this.diffMap.getUnmatchedSourceEntities().contains(sourceEntity) && this.diffMap.getUnmatchedTargetEntities().contains(targetEntity)) {
                this.diffMap.addMatch(sourceEntity, targetEntity, bean.getExplanation());
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)(sourceEntity + " was deprecated but found a better refactor operation:"));
            LOGGER.debug((Object)("\t" + sourceEntity + " -> " + this.diffMap.getEntityMap().get(sourceEntity)));
        }
    }

    @Override
    public void reset() {
        this.dds = null;
        this.diffMap.removeDiffListener(this.listener);
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public AlignmentAggressiveness getAggressiveness() {
        return AlignmentAggressiveness.AGGRESSIVE_SEARCH;
    }

    @Override
    public String getAlgorithmName() {
        return "Defer aligning source entity with deprecated target";
    }
}

