/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.protege.owl.diff.DifferencePosition;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.AlignmentListener;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.UnmatchedSourceAxiom;
import org.protege.owl.diff.service.SiblingService;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public abstract class AbstractSiblingMatch
implements AlignmentAlgorithm {
    private boolean alreadyRun = false;
    private Engine e;
    private OwlDiffMap diffs;
    private SiblingService siblingService;
    private Set<OWLClass> examinedSourceParents = new HashSet<OWLClass>();
    private AlignmentListener listener = new AlignmentListener(){

        @Override
        public void unmatchedAxiomMoved(UnmatchedSourceAxiom unmatched) {
        }

        @Override
        public void addUnmatcheableAxiom(OWLAxiom axiom) {
        }

        @Override
        public void addMatchingEntities(Map<OWLEntity, OWLEntity> newMatches) {
            AbstractSiblingMatch.this.startSearch();
            for (Map.Entry<OWLEntity, OWLEntity> entry : newMatches.entrySet()) {
                OWLEntity source = entry.getKey();
                OWLEntity target = entry.getValue();
                this.addMatchInternal(source, target);
            }
        }

        @Override
        public void addMatchingAnonymousIndividuals(Map<OWLAnonymousIndividual, OWLAnonymousIndividual> newMatches) {
        }

        @Override
        public void addMatchedAxiom(OWLAxiom axiom) {
        }

        @Override
        public void addMatch(OWLAnonymousIndividual source, OWLAnonymousIndividual target) {
        }

        @Override
        public void addMatch(OWLEntity source, OWLEntity target) {
            AbstractSiblingMatch.this.startSearch();
            this.addMatchInternal(source, target);
        }

        private void addMatchInternal(OWLEntity source, OWLEntity target) {
            if (source instanceof OWLClass && target instanceof OWLClass) {
                AbstractSiblingMatch.this.checkChildren((OWLClass)source, (OWLClass)target);
                AbstractSiblingMatch.this.checkSiblings((OWLClass)source);
            }
        }
    };

    @Override
    public abstract String getAlgorithmName();

    protected abstract void checkSiblings(OWLClass var1, Set<OWLClass> var2, OWLClass var3, Set<OWLClass> var4);

    @Override
    public void initialise(Engine e) {
        this.e = e;
        this.diffs = e.getOwlDiffMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.alreadyRun) {
            return;
        }
        this.diffs.announce(this);
        try {
            this.startSearch();
            for (OWLEntity unmatchedSource : new ArrayList<OWLEntity>(this.diffs.getUnmatchedSourceEntities())) {
                if (!(unmatchedSource instanceof OWLClass)) continue;
                this.checkSiblings((OWLClass)unmatchedSource);
            }
            this.diffs.addDiffListener(this.listener);
        }
        finally {
            this.diffs.summarize();
            this.alreadyRun = true;
        }
    }

    protected Engine getEngine() {
        return this.e;
    }

    protected SiblingService getSiblingService() {
        if (this.siblingService == null) {
            this.siblingService = SiblingService.get(this.e);
        }
        return this.siblingService;
    }

    protected OwlDiffMap getOwlDiffMap() {
        return this.diffs;
    }

    private void startSearch() {
        this.examinedSourceParents.clear();
    }

    private void checkSiblings(OWLClass sourceSibling) {
        for (OWLClass sourceParent : this.getSiblingService().getSourceSuperClasses(sourceSibling)) {
            OWLClass targetParent = (OWLClass)this.diffs.getEntityMap().get(sourceParent);
            if (targetParent == null) continue;
            this.checkChildren(sourceParent, targetParent);
        }
    }

    private void checkChildren(OWLClass sourceParent, OWLClass targetParent) {
        if (!this.examinedSourceParents.contains(sourceParent)) {
            this.examinedSourceParents.add(sourceParent);
            Set<OWLClass> sourceChildren = this.getSiblingService().getSubClasses(sourceParent, DifferencePosition.SOURCE);
            Set<OWLClass> targetChildren = this.getSiblingService().getSubClasses(targetParent, DifferencePosition.TARGET);
            this.checkSiblings(sourceParent, this.filterMatchedSiblings(sourceChildren, DifferencePosition.SOURCE), targetParent, this.filterMatchedSiblings(targetChildren, DifferencePosition.TARGET));
        }
    }

    private Set<OWLClass> filterMatchedSiblings(Set<OWLClass> siblings, DifferencePosition position) {
        TreeSet<OWLClass> unmatchedSiblings = new TreeSet<OWLClass>();
        Set<OWLEntity> unmatched = position.getUnmatchedEntities(this.diffs);
        for (OWLClass sibling : siblings) {
            if (!unmatched.contains(sibling)) continue;
            unmatchedSiblings.add(sibling);
        }
        return unmatchedSiblings;
    }

    @Override
    public void reset() {
        this.alreadyRun = false;
        this.examinedSourceParents.clear();
        this.diffs.removeDiffListener(this.listener);
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public int getPriority() {
        return 1;
    }
}

