/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.align.algorithms;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.protege.owl.diff.DifferencePosition;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.algorithms.AbstractSiblingMatch;
import org.protege.owl.diff.align.util.CompareNames;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public abstract class AbstractApproximateSiblingMatch
extends AbstractSiblingMatch {
    @Override
    public abstract String getAlgorithmName();

    public abstract String getBrowserText(OWLClass var1, DifferencePosition var2);

    protected abstract AlignmentExplanation getExplanation();

    @Override
    protected void checkSiblings(OWLClass sourceParent, Set<OWLClass> unmatchedSourceSiblings, OWLClass targetParent, Set<OWLClass> unmatchedTargetSiblings) {
        TreeMap<OWLEntity, OWLEntity> newMatches = new TreeMap<OWLEntity, OWLEntity>();
        for (OWLClass unmatchedSourceSibling : unmatchedSourceSiblings) {
            for (OWLClass unmatchedTargetSibling : unmatchedTargetSiblings) {
                this.checkMatch(newMatches, sourceParent, unmatchedSourceSibling, targetParent, unmatchedTargetSibling);
            }
        }
        this.getOwlDiffMap().addMatchingEntities(newMatches, this.getExplanation());
    }

    protected boolean checkMatch(Map<OWLEntity, OWLEntity> newMatches, OWLClass sourceParent, OWLClass unmatchedSourceSibling, OWLClass targetParent, OWLClass unmatchedTargetSibling) {
        String targetName;
        String sourceName = this.getBrowserText(unmatchedSourceSibling, DifferencePosition.SOURCE);
        if (CompareNames.closeEnough(sourceName, targetName = this.getBrowserText(unmatchedTargetSibling, DifferencePosition.TARGET))) {
            newMatches.put((OWLEntity)unmatchedSourceSibling, (OWLEntity)unmatchedTargetSibling);
            return true;
        }
        return false;
    }
}

