/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.log4j.Logger;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.impl.OwlDiffMapImpl;
import org.protege.owl.diff.align.util.PrioritizedComparator;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.PresentationAlgorithm;
import org.protege.owl.diff.present.util.PresentationAlgorithmComparator;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;

public class Engine {
    private Logger logger = Logger.getLogger(Engine.class);
    private OWLDataFactory factory;
    private OWLOntology ontology1;
    private OWLOntology ontology2;
    private Map<String, String> parameters;
    private OwlDiffMap diffMap;
    private List<AlignmentAlgorithm> diffAlgorithms = new ArrayList<AlignmentAlgorithm>();
    private Changes changes;
    private List<PresentationAlgorithm> changeAlgorithms = new ArrayList<PresentationAlgorithm>();
    private Collection<Object> services = new ArrayList<Object>();

    public Engine(OWLOntology ontology1, OWLOntology ontology2) {
        this.factory = ontology2.getOWLOntologyManager().getOWLDataFactory();
        this.ontology1 = ontology1;
        this.ontology2 = ontology2;
        this.parameters = new HashMap<String, String>();
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.factory;
    }

    public OwlDiffMap getOwlDiffMap() {
        return this.diffMap;
    }

    public Changes getChanges() {
        return this.changes;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setAlignmentAlgorithms(AlignmentAlgorithm ... algorithms) {
        this.diffAlgorithms.clear();
        for (AlignmentAlgorithm algorithm : algorithms) {
            this.diffAlgorithms.add(algorithm);
        }
        Collections.sort(this.diffAlgorithms, new PrioritizedComparator());
    }

    public Collection<AlignmentAlgorithm> getAlignmentAlgorithms() {
        return Collections.unmodifiableList(this.diffAlgorithms);
    }

    public void setPresentationAlgorithms(PresentationAlgorithm ... algorithms) {
        this.changeAlgorithms.clear();
        for (PresentationAlgorithm algorithm : algorithms) {
            this.changeAlgorithms.add(algorithm);
        }
        Collections.sort(this.changeAlgorithms, new PresentationAlgorithmComparator());
    }

    public Collection<PresentationAlgorithm> getPresentationAlgorithms() {
        return Collections.unmodifiableList(this.changeAlgorithms);
    }

    public void addService(Object o) {
        this.services.add(o);
    }

    public <X> X getService(Class<? extends X> implementing) {
        for (Object o : this.services) {
            if (!implementing.isAssignableFrom(o.getClass())) continue;
            return implementing.cast(o);
        }
        return null;
    }

    public void display() {
        SortedSet<EntityBasedDiff> ediffs = this.changes.getEntityBasedDiffs();
        for (EntityBasedDiff ediff : ediffs) {
            if (ediff.getDiffType() == EntityBasedDiff.DiffType.EQUIVALENT) continue;
            this.logger.info((Object)ediff.getDescription());
        }
    }

    public void phase1() {
        this.phase1Init();
        this.phase1Run();
        this.phase1Cleanup();
    }

    private void phase1Init() {
        this.services.clear();
        this.diffMap = new OwlDiffMapImpl(this.factory, this.ontology1, this.ontology2);
        for (AlignmentAlgorithm algorithm : this.diffAlgorithms) {
            algorithm.initialise(this);
        }
    }

    private void phase1Run() {
        boolean progress;
        boolean finished = false;
        block3: do {
            progress = false;
            for (AlignmentAlgorithm da : this.diffAlgorithms) {
                int entitiesCount = this.diffMap.getUnmatchedSourceEntities().size();
                int individualsCount = this.diffMap.getUnmatchedSourceAnonymousIndividuals().size();
                if (entitiesCount == 0 && individualsCount == 0) {
                    finished = true;
                    continue block3;
                }
                try {
                    da.run();
                }
                catch (Error e) {
                    this.logger.warn((Object)("Diff Algorithm " + da.getAlgorithmName() + "failed (" + e + ").  Continuing..."));
                }
                catch (Exception t) {
                    this.logger.warn((Object)("Diff Algorithm " + da.getAlgorithmName() + "failed (" + t + ").  Continuing..."));
                }
                progress = progress || entitiesCount > this.diffMap.getUnmatchedSourceEntities().size() || individualsCount > this.diffMap.getUnmatchedSourceAnonymousIndividuals().size();
            }
        } while (progress && !finished);
        this.diffMap.finish();
    }

    private void phase1Cleanup() {
        for (AlignmentAlgorithm algorithm : this.diffAlgorithms) {
            try {
                algorithm.reset();
            }
            catch (Error t) {
                this.logger.warn((Object)("Diff Algorithm " + algorithm.getAlgorithmName() + " wouldn't reset (" + t + ")"));
            }
            catch (Exception t) {
                this.logger.warn((Object)("Diff Algorithm " + algorithm.getAlgorithmName() + " wouldn't reset (" + t + ")"));
            }
        }
    }

    public void phase2() {
        this.phase2Init();
        this.phase2Run();
    }

    private void phase2Init() {
        this.changes = new Changes(this.diffMap);
        for (PresentationAlgorithm algorithm : this.changeAlgorithms) {
            algorithm.initialise(this);
        }
    }

    private void phase2Run() {
        for (PresentationAlgorithm algorithm : this.changeAlgorithms) {
            algorithm.apply();
        }
    }
}

