/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.individual;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.protege.editor.core.ui.RefreshableComponent;
import org.protege.editor.core.ui.view.DisposableAction;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.hierarchy.IndividualsByTypeHierarchyProvider;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.action.DeleteIndividualAction;
import org.protege.editor.owl.ui.tree.CountingOWLObjectTreeCellRenderer;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.protege.editor.owl.ui.tree.OWLTreeDragAndDropHandler;
import org.protege.editor.owl.ui.view.AbstractOWLSelectionViewComponent;
import org.protege.editor.owl.ui.view.ChangeListenerMediator;
import org.protege.editor.owl.ui.view.CreateNewTarget;
import org.protege.editor.owl.ui.view.Findable;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

public class OWLIndividualsByTypeViewComponent
extends AbstractOWLSelectionViewComponent
implements Findable<OWLNamedIndividual>,
CreateNewTarget,
RefreshableComponent {
    private static final long serialVersionUID = 1839126141881937525L;
    private OWLObjectTree<OWLObject> tree;
    private ChangeListenerMediator changeListenerMediator;
    private TreeSelectionListener listener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            OWLIndividualsByTypeViewComponent.this.transmitSelection();
        }
    };

    @Override
    public void initialiseView() throws Exception {
        this.setLayout(new BorderLayout());
        this.tree = new OWLModelManagerTree<OWLObject>(this.getOWLEditorKit(), this.getProvider());
        this.tree.setCellRenderer(new CountingOWLObjectTreeCellRenderer<OWLObject>(this.getOWLEditorKit(), this.tree));
        this.add(new JScrollPane(this.tree));
        this.changeListenerMediator = new ChangeListenerMediator();
        this.tree.addTreeSelectionListener(this.listener);
        this.tree.setDragAndDropHandler(new OWLTreeDragAndDropHandler<OWLObject>(){

            @Override
            public boolean canDrop(Object child, Object parent) {
                return child instanceof OWLNamedIndividual && parent instanceof OWLClass;
            }

            @Override
            public void move(OWLObject child, OWLObject fromParent, OWLObject toParent) {
                OWLIndividualsByTypeViewComponent.this.handleMove(child, fromParent, toParent);
            }

            @Override
            public void add(OWLObject child, OWLObject parent) {
                OWLIndividualsByTypeViewComponent.this.handleAdd(child, parent);
            }
        });
        this.setupActions();
    }

    private IndividualsByTypeHierarchyProvider getProvider() {
        return this.getOWLModelManager().getOWLHierarchyManager().getOWLIndividualsByTypeHierarchyProvider();
    }

    private void handleAdd(OWLObject child, OWLObject toParent) {
        if (child instanceof OWLNamedIndividual) {
            OWLNamedIndividual ind = (OWLNamedIndividual)child;
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
            if (toParent != null && toParent instanceof OWLClass) {
                OWLClass to = (OWLClass)toParent;
                OWLClassAssertionAxiom ax = this.getOWLModelManager().getOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)to, (OWLIndividual)ind);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
            }
            this.getOWLModelManager().applyChanges(changes);
        }
    }

    private void handleMove(OWLObject child, OWLObject fromParent, OWLObject toParent) {
        if (child instanceof OWLNamedIndividual) {
            OWLClassAssertionAxiom ax;
            OWLNamedIndividual ind = (OWLNamedIndividual)child;
            ArrayList<Object> changes = new ArrayList<Object>();
            if (toParent != null && toParent instanceof OWLClass) {
                OWLClass to = (OWLClass)toParent;
                ax = this.getOWLModelManager().getOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)to, (OWLIndividual)ind);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
            }
            if (fromParent != null && fromParent instanceof OWLClass) {
                OWLClass from = (OWLClass)fromParent;
                ax = this.getOWLModelManager().getOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)from, (OWLIndividual)ind);
                for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
                    if (!ont.containsAxiom((OWLAxiom)ax)) continue;
                    changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
                }
            }
            this.getOWLModelManager().applyChanges(changes);
        }
    }

    protected void setupActions() {
        this.addAction(new DisposableAction("Add individual", OWLIcons.getIcon("individual.add.png")){
            private static final long serialVersionUID = -875266874305923355L;

            public void actionPerformed(ActionEvent e) {
                OWLIndividualsByTypeViewComponent.this.createNewObject();
            }

            public void dispose() {
            }
        }, "A", "A");
        this.addAction(new DeleteIndividualAction(this.getOWLEditorKit(), new OWLEntitySetProvider<OWLNamedIndividual>(){

            public Set<OWLNamedIndividual> getEntities() {
                return OWLIndividualsByTypeViewComponent.this.getSelectedIndividuals();
            }
        }), "B", "A");
    }

    @Override
    public void disposeView() {
        this.tree.dispose();
    }

    @Override
    protected boolean isOWLClassView() {
        return true;
    }

    @Override
    protected boolean isOWLIndividualView() {
        return true;
    }

    @Override
    protected final OWLObject updateView() {
        OWLObject sel = null;
        OWLEntity entity = this.getOWLWorkspace().getOWLSelectionModel().getSelectedEntity();
        if (entity instanceof OWLClass || entity instanceof OWLNamedIndividual) {
            sel = this.updateView((OWLObject)entity);
            if (sel != null) {
                this.updateRegisteredActions();
            } else {
                this.disableRegisteredActions();
            }
        }
        return sel;
    }

    private Set<OWLNamedIndividual> getSelectedIndividuals() {
        List<OWLObject> sel = this.tree.getSelectedOWLObjects();
        HashSet<OWLNamedIndividual> selIndivs = new HashSet<OWLNamedIndividual>();
        for (OWLObject obj : sel) {
            if (!(obj instanceof OWLNamedIndividual)) continue;
            selIndivs.add((OWLNamedIndividual)obj);
        }
        return selIndivs;
    }

    private OWLObject updateView(OWLObject selectedEntity) {
        OWLObject selObj = this.tree.getSelectedOWLObject();
        if (selectedEntity != null && selObj != null && selectedEntity.equals(selObj)) {
            return selectedEntity;
        }
        this.tree.setSelectedOWLObject(selectedEntity);
        return selectedEntity;
    }

    private void transmitSelection() {
        OWLObject obj;
        if (this.isSynchronizing() && (obj = this.tree.getSelectedOWLObject()) instanceof OWLEntity) {
            this.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity((OWLEntity)obj);
        }
        this.changeListenerMediator.fireStateChanged(this);
    }

    @Override
    public List<OWLNamedIndividual> find(String match) {
        return new ArrayList<OWLNamedIndividual>(this.getOWLModelManager().getOWLEntityFinder().getMatchingOWLIndividuals(match));
    }

    @Override
    public void show(OWLNamedIndividual owlEntity) {
        this.tree.setSelectedOWLObject((OWLObject)owlEntity);
    }

    public boolean canDelete() {
        return !this.getSelectedIndividuals().isEmpty();
    }

    public void handleDelete() {
    }

    @Override
    public boolean canCreateNew() {
        return true;
    }

    @Override
    public void createNewObject() {
        OWLEntityCreationSet<OWLNamedIndividual> set = this.getOWLWorkspace().createOWLIndividual();
        if (set == null) {
            return;
        }
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.addAll(set.getOntologyChanges());
        this.getOWLModelManager().applyChanges(changes);
        OWLNamedIndividual ind = set.getOWLEntity();
        if (ind != null) {
            this.tree.setSelectedOWLObject((OWLObject)ind, false);
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeListenerMediator.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerMediator.removeChangeListener(listener);
    }
}

