/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.individual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.ui.RefreshableComponent;
import org.protege.editor.core.ui.view.DisposableAction;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.action.DeleteIndividualAction;
import org.protege.editor.owl.ui.list.OWLObjectList;
import org.protege.editor.owl.ui.view.ChangeListenerMediator;
import org.protege.editor.owl.ui.view.CreateNewTarget;
import org.protege.editor.owl.ui.view.Deleteable;
import org.protege.editor.owl.ui.view.Findable;
import org.protege.editor.owl.ui.view.individual.AbstractOWLIndividualViewComponent;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.OWLEntityCollector;
import org.semanticweb.owlapi.util.OWLEntityRemover;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

public class OWLIndividualListViewComponent
extends AbstractOWLIndividualViewComponent
implements Findable<OWLNamedIndividual>,
Deleteable,
CreateNewTarget,
RefreshableComponent {
    private static final long serialVersionUID = -1519269944342726754L;
    private OWLObjectList<OWLNamedIndividual> list;
    private OWLOntologyChangeListener listener;
    private ChangeListenerMediator changeListenerMediator;
    private OWLModelManagerListener modelManagerListener;
    private int selectionMode = 2;
    private boolean selectionChangedByUser = true;
    protected Set<OWLNamedIndividual> individualsInList;
    private ListSelectionListener listSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (OWLIndividualListViewComponent.this.list.getSelectedValue() != null && OWLIndividualListViewComponent.this.selectionChangedByUser) {
                    OWLIndividualListViewComponent.this.setGlobalSelection((OWLEntity)((OWLNamedIndividual)OWLIndividualListViewComponent.this.list.getSelectedValue()));
                }
                OWLIndividualListViewComponent.this.changeListenerMediator.fireStateChanged(OWLIndividualListViewComponent.this);
            }
        }
    };

    @Override
    public void initialiseIndividualsView() throws Exception {
        this.list = new OWLObjectList(this.getOWLEditorKit());
        this.list.setSelectionMode(this.selectionMode);
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.list));
        this.list.addListSelectionListener(this.listSelectionListener);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                OWLIndividualListViewComponent.this.setGlobalSelection((OWLEntity)((OWLNamedIndividual)OWLIndividualListViewComponent.this.list.getSelectedValue()));
            }
        });
        this.listener = new OWLOntologyChangeListener(){

            public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
                OWLIndividualListViewComponent.this.processChanges(changes);
            }
        };
        this.getOWLModelManager().addOntologyChangeListener(this.listener);
        this.setupActions();
        this.changeListenerMediator = new ChangeListenerMediator();
        this.individualsInList = new TreeSet<OWLObject>(this.getOWLModelManager().getOWLObjectComparator());
        this.refill();
        this.modelManagerListener = new OWLModelManagerListener(){

            @Override
            public void handleChange(OWLModelManagerChangeEvent event) {
                if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ONTOLOGY_RELOADED)) {
                    OWLIndividualListViewComponent.this.refill();
                }
            }
        };
        this.getOWLModelManager().addListener(this.modelManagerListener);
    }

    protected void setupActions() {
        this.addAction(new AddIndividualAction(), "A", "A");
        this.addAction(new DeleteIndividualAction(this.getOWLEditorKit(), new OWLEntitySetProvider<OWLNamedIndividual>(){

            public Set<OWLNamedIndividual> getEntities() {
                return OWLIndividualListViewComponent.this.getSelectedIndividuals();
            }
        }), "B", "A");
    }

    @Override
    public void refreshComponent() {
        this.refill();
    }

    protected void refill() {
        this.individualsInList.clear();
        for (OWLOntology ont : this.getOntologies()) {
            this.individualsInList.addAll(ont.getIndividualsInSignature());
        }
        this.reset();
    }

    protected Set<OWLOntology> getOntologies() {
        return this.getOWLModelManager().getActiveOntologies();
    }

    public void setSelectedIndividual(OWLIndividual individual) {
        this.list.setSelectedValue(individual, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        this.list.setListData((Object[])this.individualsInList.toArray());
        OWLNamedIndividual individual = this.getSelectedOWLIndividual();
        this.selectionChangedByUser = false;
        try {
            this.list.setSelectedValue(individual, true);
        }
        finally {
            this.selectionChangedByUser = true;
        }
    }

    @Override
    public OWLNamedIndividual updateView(OWLNamedIndividual selelectedIndividual) {
        if (!this.isPinned()) {
            this.list.setSelectedValue(selelectedIndividual, true);
        }
        return (OWLNamedIndividual)this.list.getSelectedValue();
    }

    @Override
    public void disposeView() {
        this.getOWLModelManager().removeOntologyChangeListener(this.listener);
        this.getOWLModelManager().removeListener(this.modelManagerListener);
    }

    public OWLNamedIndividual getSelectedIndividual() {
        return (OWLNamedIndividual)this.list.getSelectedValue();
    }

    public Set<OWLNamedIndividual> getSelectedIndividuals() {
        HashSet<OWLNamedIndividual> inds = new HashSet<OWLNamedIndividual>();
        for (Object obj : this.list.getSelectedValues()) {
            inds.add((OWLNamedIndividual)obj);
        }
        return inds;
    }

    protected void processChanges(List<? extends OWLOntologyChange> changes) {
        HashSet possiblyAddedObjects = new HashSet();
        HashSet possiblyRemovedObjects = new HashSet();
        OWLEntityCollector addedCollector = new OWLEntityCollector(possiblyAddedObjects);
        OWLEntityCollector removedCollector = new OWLEntityCollector(possiblyRemovedObjects);
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            OWLAxiomChange axChg = (OWLAxiomChange)oWLOntologyChange;
            if (axChg instanceof AddAxiom) {
                axChg.getAxiom().accept((OWLObjectVisitor)addedCollector);
                continue;
            }
            axChg.getAxiom().accept((OWLObjectVisitor)removedCollector);
        }
        boolean mod = false;
        for (OWLEntity ent : possiblyAddedObjects) {
            if (!(ent instanceof OWLIndividual) || !this.individualsInList.add((OWLNamedIndividual)ent)) continue;
            mod = true;
        }
        for (OWLEntity ent : possiblyRemovedObjects) {
            if (!(ent instanceof OWLIndividual)) continue;
            boolean stillReferenced = false;
            for (OWLOntology ont : this.getOntologies()) {
                if (!ont.containsIndividualInSignature(ent.getIRI())) continue;
                stillReferenced = true;
                break;
            }
            if (stillReferenced || !this.individualsInList.remove(ent)) continue;
            mod = true;
        }
        if (mod) {
            this.reset();
        }
    }

    protected void addIndividual() {
        OWLEntityCreationSet<OWLNamedIndividual> set = this.getOWLWorkspace().createOWLIndividual();
        if (set == null) {
            return;
        }
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.addAll(set.getOntologyChanges());
        changes.addAll(this.dofurtherCreateSteps((OWLIndividual)set.getOWLEntity()));
        this.getOWLModelManager().applyChanges(changes);
        OWLNamedIndividual ind = set.getOWLEntity();
        if (ind != null) {
            this.list.setSelectedValue(ind, true);
        }
    }

    protected List<OWLOntologyChange> dofurtherCreateSteps(OWLIndividual newIndividual) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<OWLNamedIndividual> find(String match) {
        return new ArrayList<OWLNamedIndividual>(this.getOWLModelManager().getOWLEntityFinder().getMatchingOWLIndividuals(match));
    }

    @Override
    public void show(OWLNamedIndividual owlEntity) {
        this.list.setSelectedValue(owlEntity, true);
    }

    public void setSelectedIndividuals(Set<OWLNamedIndividual> individuals) {
        this.list.setSelectedValues(individuals, true);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeListenerMediator.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerMediator.removeChangeListener(listener);
    }

    @Override
    public void handleDelete() {
        OWLEntityRemover entityRemover = new OWLEntityRemover(this.getOWLModelManager().getOWLOntologyManager(), this.getOWLModelManager().getOntologies());
        for (OWLNamedIndividual ind : this.getSelectedIndividuals()) {
            ind.accept((OWLEntityVisitor)entityRemover);
        }
        this.getOWLModelManager().applyChanges(entityRemover.getChanges());
    }

    @Override
    public boolean canDelete() {
        return !this.getSelectedIndividuals().isEmpty();
    }

    @Override
    public boolean canCreateNew() {
        return true;
    }

    @Override
    public void createNewObject() {
        this.addIndividual();
    }

    public void setSelectionMode(int selectionMode) {
        if (this.list != null) {
            this.list.setSelectionMode(selectionMode);
        }
    }

    public void setIndividualListColor(Color c) {
        this.list.setBackground(c);
    }

    private class AddIndividualAction
    extends DisposableAction {
        private static final long serialVersionUID = 4574601252717263757L;

        public AddIndividualAction() {
            super("Add individual", OWLIcons.getIcon("individual.add.png"));
        }

        public void actionPerformed(ActionEvent e) {
            OWLIndividualListViewComponent.this.addIndividual();
        }

        public void dispose() {
        }
    }
}

