/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.protege.editor.core.ui.util.Resettable;
import org.protege.editor.core.ui.view.ViewsPane;
import org.protege.editor.core.ui.view.ViewsPaneMemento;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class SelectedEntityCardView
extends AbstractOWLViewComponent
implements Resettable {
    private static final long serialVersionUID = -287697571704681093L;
    public static final String ID = "org.protege.editor.owl.SelectedEntityView";
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel;
    private List<ViewsPane> viewsPanes = new ArrayList<ViewsPane>();
    private static final String CLASSES_PANEL = "Classes";
    private static final String OBJECT_PROPERTIES_PANEL = "ObjectProperties";
    private static final String DATA_PROPERTIES_PANEL = "DataProperties";
    private static final String ANNOTATION_PROPERTIES_PANEL = "AnnotationProperties";
    private static final String INDIVIDUALS_PANEL = "Individual";
    private static final String DATATYPES_PANEL = "Datatypes";
    private static final String BLANK_PANEL = "Blank";

    @Override
    protected void initialiseOWLView() throws Exception {
        this.setLayout(new BorderLayout());
        this.cardPanel = new JPanel();
        this.add(this.cardPanel);
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add((Component)new JPanel(), BLANK_PANEL);
        this.createViewPanes(false);
        this.getOWLWorkspace().getOWLSelectionModel().addListener(new OWLSelectionModelListener(){

            @Override
            public void selectionChanged() throws Exception {
                SelectedEntityCardView.this.processSelection();
            }
        });
        this.getView().setShowViewBar(false);
        this.processSelection();
    }

    private void createViewPanes(boolean reset) {
        this.addPane(CLASSES_PANEL, "/selected-entity-view-class-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.classes", reset);
        this.addPane(OBJECT_PROPERTIES_PANEL, "/selected-entity-view-objectproperty-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.objectproperties", reset);
        this.addPane(DATA_PROPERTIES_PANEL, "/selected-entity-view-dataproperty-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.dataproperties", reset);
        this.addPane(ANNOTATION_PROPERTIES_PANEL, "/selected-entity-view-annotationproperty-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.annotproperties", reset);
        this.addPane(INDIVIDUALS_PANEL, "/selected-entity-view-individual-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.individuals", reset);
        this.addPane(DATATYPES_PANEL, "/selected-entity-view-datatype-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.datatypes", reset);
    }

    private void addPane(String panelId, String configFile, String viewPaneId, boolean reset) {
        URL clsURL = ((Object)((Object)this)).getClass().getResource(configFile);
        ViewsPane pane = new ViewsPane((Workspace)this.getOWLWorkspace(), new ViewsPaneMemento(clsURL, viewPaneId, reset));
        this.cardPanel.add((Component)pane, panelId);
        this.viewsPanes.add(pane);
    }

    public void reset() {
        for (ViewsPane pane : this.viewsPanes) {
            this.cardPanel.remove((Component)pane);
            pane.dispose();
        }
        this.viewsPanes.clear();
        this.createViewPanes(true);
        this.validate();
        for (ViewsPane pane : this.viewsPanes) {
            pane.saveViews();
        }
    }

    private void processSelection() {
        OWLEntity entity = this.getOWLWorkspace().getOWLSelectionModel().getSelectedEntity();
        if (entity == null) {
            this.selectPanel(BLANK_PANEL);
        } else {
            entity.accept(new OWLEntityVisitor(){

                public void visit(OWLClass cls) {
                    SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.CLASSES_PANEL);
                }

                public void visit(OWLObjectProperty property) {
                    SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.OBJECT_PROPERTIES_PANEL);
                }

                public void visit(OWLDataProperty property) {
                    SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.DATA_PROPERTIES_PANEL);
                }

                public void visit(OWLAnnotationProperty property) {
                    SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.ANNOTATION_PROPERTIES_PANEL);
                }

                public void visit(OWLNamedIndividual individual) {
                    SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.INDIVIDUALS_PANEL);
                }

                public void visit(OWLDatatype dataType) {
                    SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.DATATYPES_PANEL);
                }
            });
        }
    }

    private void selectPanel(String name) {
        this.cardLayout.show(this.cardPanel, name);
    }

    @Override
    protected void disposeOWLView() {
        for (ViewsPane pane : this.viewsPanes) {
            pane.saveViews();
            pane.dispose();
        }
    }
}

