/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.tree.OWLTreeDragAndDropHandler;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.RemoveAxiom;

public abstract class OWLPropertyTreeDropHandler<N extends OWLPropertyExpression>
implements OWLTreeDragAndDropHandler<N> {
    private static final Logger logger = Logger.getLogger(OWLPropertyTreeDropHandler.class);
    private OWLModelManager owlModelManager;

    public OWLPropertyTreeDropHandler(OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
    }

    @Override
    public void move(N child, N fromParent, N toParent) {
        ArrayList<Object> changes = new ArrayList<Object>();
        OWLDataFactory df = this.owlModelManager.getOWLDataFactory();
        changes.add(new AddAxiom(this.owlModelManager.getActiveOntology(), this.getAxiom(df, child, toParent)));
        if (fromParent != null) {
            changes.add(new RemoveAxiom(this.owlModelManager.getActiveOntology(), this.getAxiom(df, child, fromParent)));
        }
        this.owlModelManager.applyChanges(changes);
    }

    @Override
    public void add(N child, N parent) {
        OWLDataFactory df = this.owlModelManager.getOWLDataFactory();
        this.owlModelManager.applyChange((OWLOntologyChange)new AddAxiom(this.owlModelManager.getActiveOntology(), this.getAxiom(df, child, parent)));
    }

    protected abstract OWLAxiom getAxiom(OWLDataFactory var1, N var2, N var3);
}

