/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.BorderLayout;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.editor.owl.model.selection.OWLSelectionModelAdapter;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.model.util.OWLAxiomInstance;
import org.protege.editor.owl.ui.axiom.AxiomAnnotationPanel;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLAxiomAnnotationsView
extends AbstractOWLViewComponent {
    private static final long serialVersionUID = -6288372193137254393L;
    private OWLSelectionModelListener selListener = new OWLSelectionModelAdapter(){

        @Override
        public void selectionChanged() throws Exception {
            OWLSelectionModel selModel = OWLAxiomAnnotationsView.this.getOWLWorkspace().getOWLSelectionModel();
            if (selModel.getLastSelectedAxiomInstance() == null || !selModel.getLastSelectedAxiomInstance().equals(OWLAxiomAnnotationsView.this.axiomAnnotationPanel.getAxiom())) {
                OWLAxiomAnnotationsView.this.updateViewContentAndHeader();
            }
        }
    };
    private HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (OWLAxiomAnnotationsView.this.needsRefresh && OWLAxiomAnnotationsView.this.isShowing()) {
                OWLAxiomAnnotationsView.this.updateViewContentAndHeader();
            }
        }
    };
    private boolean needsRefresh = true;
    private boolean initialUpdatePerformed = false;
    private OWLAxiom lastDisplayedObject;
    private AxiomAnnotationPanel axiomAnnotationPanel;

    @Override
    protected void initialiseOWLView() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        this.axiomAnnotationPanel = new AxiomAnnotationPanel(this.getOWLEditorKit());
        this.add(this.axiomAnnotationPanel, "Center");
        this.getOWLWorkspace().getOWLSelectionModel().addListener(this.selListener);
        this.addHierarchyListener(this.hierarchyListener);
    }

    protected void updateViewContentAndHeader() {
        if (!this.isShowing()) {
            this.needsRefresh = true;
            return;
        }
        this.needsRefresh = false;
        if (this.isPinned() && this.initialUpdatePerformed) {
            return;
        }
        this.initialUpdatePerformed = true;
        if (this.isSynchronizing()) {
            this.lastDisplayedObject = this.updateView();
            this.updateHeader(this.lastDisplayedObject);
        }
    }

    private void updateHeader(OWLAxiom axiom) {
        String title = "";
        if (axiom != null && (title = this.getOWLModelManager().getRendering((OWLObject)axiom).replace('\n', ' ')).length() > 53) {
            title = title.substring(0, 50) + "...";
        }
        this.getView().setHeaderText(title);
    }

    private OWLAxiom updateView() {
        OWLAxiomInstance axiomInstance = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedAxiomInstance();
        this.axiomAnnotationPanel.setAxiomInstance(axiomInstance);
        return axiomInstance != null ? axiomInstance.getAxiom() : null;
    }

    @Override
    protected void disposeOWLView() {
        this.getOWLWorkspace().getOWLSelectionModel().removeListener(this.selListener);
        this.removeHierarchyListener(this.hierarchyListener);
        this.axiomAnnotationPanel.dispose();
    }
}

