/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.owl.model.classexpression.anonymouscls.AnonymousDefinedClassManager;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.view.AbstractActiveOntologyViewComponent;
import org.protege.editor.owl.ui.view.Copyable;
import org.protege.editor.owl.ui.view.Deleteable;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLEntityRemover;

public class AnonymousClassesView
extends AbstractActiveOntologyViewComponent
implements Deleteable,
Copyable {
    private static final long serialVersionUID = 6603279963895348251L;
    private MList list;
    private OWLEntityRemover remover;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    @Override
    protected void initialiseOntologyView() throws Exception {
        this.setLayout(new BorderLayout());
        this.list = new MList();
        MList.MListCellRenderer ren = (MList.MListCellRenderer)this.list.getCellRenderer();
        ren.setContentRenderer((ListCellRenderer)new OWLCellRenderer(this.getOWLEditorKit(), true, true){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof AnonymousClassItem) {
                    value = ((AnonymousClassItem)value).getOWLClass();
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.add((Component)this.list, "Center");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                for (ChangeListener l : new ArrayList(AnonymousClassesView.this.listeners)) {
                    l.stateChanged(new ChangeEvent(AnonymousClassesView.this));
                }
                Object item = AnonymousClassesView.this.list.getSelectedValue();
                if (item != null) {
                    AnonymousClassesView.this.getOWLEditorKit().getOWLWorkspace().getOWLSelectionModel().setSelectedEntity((OWLEntity)((AnonymousClassItem)item).getOWLClass());
                }
            }
        });
        this.remover = new OWLEntityRemover(this.getOWLModelManager().getOWLOntologyManager(), this.getOWLModelManager().getOntologies());
    }

    @Override
    protected void disposeOntologyView() {
    }

    @Override
    protected void updateView(OWLOntology activeOntology) throws Exception {
        HashSet<AnonymousClassItem> clses = new HashSet<AnonymousClassItem>();
        AnonymousDefinedClassManager ADCManager = (AnonymousDefinedClassManager)this.getOWLModelManager().get(AnonymousDefinedClassManager.ID);
        if (ADCManager != null) {
            for (OWLClass cls : activeOntology.getClassesInSignature()) {
                if (!ADCManager.isAnonymous(cls)) continue;
                clses.add(new AnonymousClassItem(cls));
            }
        }
        this.list.setListData(clses.toArray());
    }

    @Override
    public boolean canDelete() {
        return this.list.getSelectedIndex() >= 0;
    }

    @Override
    public void handleDelete() {
        this.remover.reset();
        for (Object clsItem : this.list.getSelectedValues()) {
            ((AnonymousClassItem)clsItem).getOWLClass().accept((OWLEntityVisitor)this.remover);
        }
        this.getOWLModelManager().applyChanges(this.remover.getChanges());
    }

    @Override
    public boolean canCopy() {
        return this.list.getSelectedIndex() >= 0;
    }

    @Override
    public List<OWLObject> getObjectsToCopy() {
        ArrayList<OWLObject> sel = new ArrayList<OWLObject>();
        for (Object clsItem : this.list.getSelectedValues()) {
            sel.add((OWLObject)((AnonymousClassItem)clsItem).getOWLClass());
        }
        return sel;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private class AnonymousClassItem
    implements MListItem {
        private OWLClass cls;

        public AnonymousClassItem(OWLClass cls) {
            this.cls = cls;
        }

        public boolean isEditable() {
            return false;
        }

        public void handleEdit() {
        }

        public boolean isDeleteable() {
            return true;
        }

        public boolean handleDelete() {
            AnonymousClassesView.this.remover.reset();
            this.cls.accept((OWLEntityVisitor)AnonymousClassesView.this.remover);
            AnonymousClassesView.this.getOWLModelManager().applyChanges(AnonymousClassesView.this.remover.getChanges());
            return true;
        }

        public String getTooltip() {
            return "";
        }

        public OWLClass getOWLClass() {
            return this.cls;
        }
    }
}

