/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.ui.find.OWLEntityFindPanel;
import org.protege.editor.owl.ui.view.Findable;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public abstract class AbstractOWLViewComponent
extends ViewComponent {
    private static final long serialVersionUID = -3089829405015180530L;
    private static final String DIALOGS_ALWAYS_CENTRED = "DIALOGS_ALWAYS_CENTRED";
    private static final Logger logger = Logger.getLogger(AbstractOWLViewComponent.class);
    private static final String INPUT_MAP_KEY = "FIND";

    public OWLModelManager getOWLModelManager() {
        return this.getOWLWorkspace().getOWLEditorKit().getModelManager();
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.getOWLWorkspace().getOWLEditorKit();
    }

    protected abstract void initialiseOWLView() throws Exception;

    public final void initialise() throws Exception {
        this.setupFinder();
        this.initialiseOWLView();
        this.prepareCopyable();
        this.preparePasteable();
        this.prepareCuttable();
    }

    private void prepareCopyable() {
        AbstractOWLViewComponent.removeFromInputMap(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), (JComponent)((Object)this));
    }

    private void preparePasteable() {
        AbstractOWLViewComponent.removeFromInputMap(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), (JComponent)((Object)this));
    }

    private void prepareCuttable() {
        AbstractOWLViewComponent.removeFromInputMap(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), (JComponent)((Object)this));
    }

    private static void removeFromInputMap(KeyStroke ks, JComponent c) {
        AbstractOWLViewComponent.removeKeyBinding(c.getInputMap(1), ks);
        AbstractOWLViewComponent.removeKeyBinding(c.getInputMap(2), ks);
        AbstractOWLViewComponent.removeKeyBinding(c.getInputMap(0), ks);
        for (Component child : c.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            AbstractOWLViewComponent.removeFromInputMap(ks, (JComponent)child);
        }
    }

    private static void removeKeyBinding(InputMap im, KeyStroke ks) {
        if (im.getParent() != null) {
            im.getParent().remove(ks);
        }
    }

    private void setupFinder() {
        if (this instanceof Findable) {
            this.getInputMap(1).put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), INPUT_MAP_KEY);
            this.getActionMap().put(INPUT_MAP_KEY, new AbstractAction(){
                private static final long serialVersionUID = 8090385169368686926L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractOWLViewComponent.this.handleFind();
                }
            });
        }
    }

    private void handleFind() {
        logger.debug((Object)("Handling find in " + this.toString()));
        Component parent = this.getDialogParent();
        OWLEntity foundEntity = OWLEntityFindPanel.showDialog(parent, this.getOWLEditorKit(), (Findable)((Object)this));
        if (foundEntity == null) {
            return;
        }
        ((Findable)((Object)this)).show(foundEntity);
    }

    private Component getDialogParent() {
        Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.core.application");
        return prefs.getBoolean(DIALOGS_ALWAYS_CENTRED, false) ? SwingUtilities.getAncestorOfClass(Frame.class, this.getParent()) : this.getParent();
    }

    protected OWLDataFactory getOWLDataFactory() {
        return this.getOWLModelManager().getOWLDataFactory();
    }

    public final void dispose() {
        this.disposeOWLView();
    }

    protected abstract void disposeOWLView();

    public OWLWorkspace getOWLWorkspace() {
        return (OWLWorkspace)this.getWorkspace();
    }

    protected OWLObject getObjectToCopy() {
        return null;
    }

    protected void handlePaste(List<OWLObject> objects) {
    }
}

