/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.util.OWLUtilities;
import org.protege.editor.owl.ui.OWLObjectComparatorAdapter;
import org.protege.editor.owl.ui.action.OWLObjectHierarchyDeleter;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.protege.editor.owl.ui.view.AbstractOWLSelectionViewComponent;
import org.protege.editor.owl.ui.view.ChangeListenerMediator;
import org.protege.editor.owl.ui.view.Deleteable;
import org.protege.editor.owl.ui.view.Findable;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

public abstract class AbstractOWLEntityHierarchyViewComponent<E extends OWLEntity>
extends AbstractOWLSelectionViewComponent
implements Findable<E>,
Deleteable {
    private static final long serialVersionUID = -5980351290853739210L;
    private OWLObjectTree<E> tree;
    private TreeSelectionListener listener;
    private OWLObjectHierarchyDeleter<E> hierarchyDeleter;
    private ChangeListenerMediator deletableChangeListenerMediator = new ChangeListenerMediator();

    @Override
    public final void initialiseView() throws Exception {
        this.setLayout(new BorderLayout(7, 7));
        this.tree = new OWLModelManagerTree<E>(this.getOWLEditorKit(), this.getHierarchyProvider());
        final Comparator<OWLObject> comp = this.getOWLModelManager().getOWLObjectComparator();
        this.tree.setOWLObjectComparator((Comparator<OWLObject>)new OWLObjectComparatorAdapter<OWLObject>(comp){

            @Override
            public int compare(OWLObject o1, OWLObject o2) {
                boolean deprecated2;
                if (AbstractOWLEntityHierarchyViewComponent.this.getOWLDataFactory().getOWLNothing().equals(o1)) {
                    return -1;
                }
                if (AbstractOWLEntityHierarchyViewComponent.this.getOWLDataFactory().getOWLNothing().equals(o2)) {
                    return 1;
                }
                boolean deprecated1 = OWLUtilities.isDeprecated(AbstractOWLEntityHierarchyViewComponent.this.getOWLModelManager(), o1);
                if (deprecated1 != (deprecated2 = OWLUtilities.isDeprecated(AbstractOWLEntityHierarchyViewComponent.this.getOWLModelManager(), o2))) {
                    return deprecated1 ? 1 : -1;
                }
                return comp.compare(o1, o2);
            }
        });
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer instanceof OWLCellRenderer) {
            ((OWLCellRenderer)treeCellRenderer).setHighlightKeywords(true);
        }
        this.initSelectionManagement();
        this.add(ComponentFactory.createScrollPane(this.tree));
        this.performExtraInitialisation();
        E entity = this.getSelectedEntity();
        if (entity != null) {
            this.setGlobalSelection((OWLEntity)entity);
        }
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                AbstractOWLEntityHierarchyViewComponent.this.ensureSelection();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                AbstractOWLEntityHierarchyViewComponent.this.ensureSelection();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                AbstractOWLEntityHierarchyViewComponent.this.ensureSelection();
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractOWLEntityHierarchyViewComponent.this.transmitSelection();
            }
        });
        this.hierarchyDeleter = new OWLObjectHierarchyDeleter<E>(this.getOWLEditorKit(), this.getHierarchyProvider(), new OWLEntitySetProvider<E>(){

            public Set<E> getEntities() {
                return new HashSet(AbstractOWLEntityHierarchyViewComponent.this.tree.getSelectedOWLObjects());
            }
        }, this.getCollectiveTypeName());
    }

    protected abstract void performExtraInitialisation() throws Exception;

    protected abstract OWLObjectHierarchyProvider<E> getHierarchyProvider();

    protected String getCollectiveTypeName() {
        return "entities";
    }

    public void setSelectedEntity(E entity) {
        this.tree.setSelectedOWLObject(entity);
    }

    public void setSelectedEntities(Set<E> entities) {
        this.tree.setSelectedOWLObjects(entities);
    }

    public E getSelectedEntity() {
        return (E)((OWLEntity)this.tree.getSelectedOWLObject());
    }

    public Set<E> getSelectedEntities() {
        return new HashSet<E>(this.tree.getSelectedOWLObjects());
    }

    private void ensureSelection() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OWLEntity treeSel;
                Object entity = AbstractOWLEntityHierarchyViewComponent.this.getSelectedEntity();
                if (!(entity == null || (treeSel = (OWLEntity)AbstractOWLEntityHierarchyViewComponent.this.tree.getSelectedOWLObject()) != null && treeSel.equals(entity))) {
                    AbstractOWLEntityHierarchyViewComponent.this.tree.setSelectedOWLObject(entity);
                }
            }
        });
    }

    public boolean requestFocusInWindow() {
        return this.tree.requestFocusInWindow();
    }

    protected OWLObjectTree<E> getTree() {
        return this.tree;
    }

    private void initSelectionManagement() {
        this.listener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AbstractOWLEntityHierarchyViewComponent.this.transmitSelection();
            }
        };
        this.tree.addTreeSelectionListener(this.listener);
    }

    protected void transmitSelection() {
        this.deletableChangeListenerMediator.fireStateChanged(this);
        E selEntity = this.getSelectedEntity();
        if (selEntity != null) {
            View view = this.getView();
            if (view != null && !view.isPinned()) {
                view.setPinned(true);
                this.setGlobalSelection((OWLEntity)selEntity);
                view.setPinned(false);
            } else {
                this.setGlobalSelection((OWLEntity)selEntity);
            }
        }
        this.updateHeader((OWLObject)selEntity);
    }

    protected E updateView(E selEntity) {
        if (this.tree.getSelectedOWLObject() == null) {
            if (selEntity != null) {
                this.tree.setSelectedOWLObject(selEntity);
            }
        } else if (!((OWLEntity)this.tree.getSelectedOWLObject()).equals(selEntity)) {
            this.tree.setSelectedOWLObject(selEntity);
        }
        return selEntity;
    }

    @Override
    public void disposeView() {
        if (this.tree != null) {
            this.tree.removeTreeSelectionListener(this.listener);
            this.tree.dispose();
        }
    }

    @Override
    protected OWLObject getObjectToCopy() {
        return this.tree.getSelectedOWLObject();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.deletableChangeListenerMediator.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.deletableChangeListenerMediator.removeChangeListener(listener);
    }

    @Override
    public void handleDelete() {
        this.hierarchyDeleter.performDeletion();
    }

    @Override
    public boolean canDelete() {
        return !this.tree.getSelectedOWLObjects().isEmpty();
    }

    @Override
    public void show(E owlEntity) {
        this.getTree().setSelectedOWLObject(owlEntity);
    }
}

