/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.table;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.protege.editor.owl.ui.transfer.OWLObjectDataFlavor;
import org.protege.editor.owl.ui.transfer.OWLObjectDropTarget;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

public class OWLObjectDropTargetListener
implements DropTargetListener {
    private static final Logger logger = Logger.getLogger(OWLObjectDropTargetListener.class);
    private Cursor orginalCursor;
    private JComponent component;
    private OWLObjectDropTarget target;

    public OWLObjectDropTargetListener(OWLObjectDropTarget target) {
        this.component = target.getComponent();
        this.target = target;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.orginalCursor = this.component.getCursor();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            dtde.acceptDrag(3);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.component.setCursor(this.orginalCursor);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (!this.isDropAcceptable(dtde)) {
            dtde.rejectDrop();
        } else {
            dtde.acceptDrop(3);
            List<OWLObject> objs = this.getDropObjects(dtde.getTransferable());
            ArrayList<OWLObject> dupObjs = new ArrayList<OWLObject>();
            OWLObject dupObj = null;
            for (OWLObject obj : objs) {
                OWLObjectDuplicator duplicator = new OWLObjectDuplicator(this.target.getOWLModelManager().getOWLDataFactory());
                dupObj = duplicator.duplicateObject(obj);
                dupObjs.add(dupObj);
            }
            dtde.dropComplete(this.target.dropOWLObjects(dupObjs, dtde.getLocation(), dtde.getDropAction()));
        }
        this.component.setCursor(this.orginalCursor);
    }

    protected boolean isDragAcceptable(DropTargetDragEvent event) {
        return this.getDropObjects(event.getTransferable()) != null;
    }

    protected boolean isDropAcceptable(DropTargetDropEvent event) {
        return this.getDropObjects(event.getTransferable()) != null;
    }

    protected List<OWLObject> getDropObjects(Transferable transferable) {
        if (!this.isAcceptableTransferable(transferable)) {
            return null;
        }
        try {
            List objs = (List)transferable.getTransferData(OWLObjectDataFlavor.OWL_OBJECT_DATA_FLAVOR);
            return objs;
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return null;
    }

    protected boolean isAcceptableTransferable(Transferable transferable) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(OWLObjectDataFlavor.OWL_OBJECT_DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }
}

