/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.protege.editor.owl.ui.renderer.layout.EmptyPageObjectBorder;
import org.protege.editor.owl.ui.renderer.layout.LinkBox;
import org.protege.editor.owl.ui.renderer.layout.Page;
import org.protege.editor.owl.ui.renderer.layout.PageObjectBorder;

public abstract class PageObject {
    private PageObject parent;
    private List<PageObject> children = new ArrayList<PageObject>();
    private Rectangle bounds = new Rectangle();
    private Insets marginInsets = new Insets(0, 0, 0, 0);
    private Insets paddingInsets = new Insets(0, 0, 0, 0);
    private boolean mouseOver = false;
    private PageObjectBorder pageObjectBorder = EmptyPageObjectBorder.getEmptyPageObjectBorder();
    private static final Color[] colors = new Color[]{Color.MAGENTA, Color.GREEN, Color.CYAN, Color.ORANGE, Color.RED, Color.YELLOW, Color.PINK};

    public void add(PageObject child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
            child.setParent(this);
            this.invalidateLayout();
        }
    }

    protected void setParent(PageObject pageObject) {
        this.parent = pageObject;
    }

    public List<PageObject> getChildren() {
        return new ArrayList<PageObject>(this.children);
    }

    public void clear() {
        Iterator<PageObject> it = this.children.iterator();
        while (it.hasNext()) {
            PageObject pageObject = it.next();
            it.remove();
            pageObject.parent = null;
        }
    }

    public PageObject getParent() {
        return this.parent;
    }

    public Page getPage() {
        if (this instanceof Page) {
            return (Page)this;
        }
        PageObject parent = this.getParent();
        if (parent != null) {
            return parent.getPage();
        }
        return null;
    }

    public void setBounds(Rectangle rectangle) {
        this.bounds.setBounds(rectangle);
    }

    public int getX() {
        return this.bounds.x;
    }

    public void setX(int x) {
        if (x != this.bounds.x) {
            this.bounds.x = x;
        }
    }

    public int getY() {
        return this.bounds.y;
    }

    public void setY(int y) {
        if (this.bounds.y != y) {
            this.bounds.y = y;
        }
    }

    public int getMarginLeft() {
        return this.marginInsets.left;
    }

    public void setMarginLeft(int marginLeft) {
        if (marginLeft < 0) {
            throw new IllegalArgumentException("marginLeft < 0");
        }
        if (this.marginInsets.left != marginLeft) {
            this.marginInsets.left = marginLeft;
            this.invalidateLayout();
        }
    }

    public int getMarginRight() {
        return this.marginInsets.right;
    }

    public void setMarginRight(int marginRight) {
        if (marginRight < 0) {
            throw new IllegalArgumentException("marginRight < 0");
        }
        if (this.marginInsets.right != marginRight) {
            this.marginInsets.right = marginRight;
            this.invalidateLayout();
        }
    }

    public int getMarginTop() {
        return this.marginInsets.top;
    }

    public void setMarginTop(int marginTop) {
        if (marginTop < 0) {
            throw new IllegalArgumentException("marginTop < 0");
        }
        if (this.marginInsets.top != marginTop) {
            this.marginInsets.top = marginTop;
            this.invalidateLayout();
        }
    }

    public int getMarginBottom() {
        return this.marginInsets.bottom;
    }

    public void setMarginBottom(int marginBottom) {
        if (marginBottom < 0) {
            throw new IllegalArgumentException("marginBottom < 0");
        }
        if (this.marginInsets.bottom != marginBottom) {
            this.marginInsets.bottom = marginBottom;
            this.invalidateLayout();
        }
    }

    public void setMargin(int margin) {
        if (margin < 0) {
            throw new IllegalArgumentException("margin < 0");
        }
        this.setMarginLeft(margin);
        this.setMarginRight(margin);
        this.setMarginTop(margin);
        this.setMarginBottom(margin);
    }

    public void setBorder(PageObjectBorder pageObjectBorder) {
        this.pageObjectBorder = pageObjectBorder;
        this.invalidateLayout();
    }

    public int getBorderLeft() {
        return this.pageObjectBorder.getLeftInset();
    }

    public int getBorderRight() {
        return this.pageObjectBorder.getRightInset();
    }

    public int getBorderTop() {
        return this.pageObjectBorder.getTopInset();
    }

    public int getBorderBottom() {
        return this.pageObjectBorder.getBottomInset();
    }

    public int getPaddingLeft() {
        return this.paddingInsets.left;
    }

    public int getPaddingRight() {
        return this.paddingInsets.right;
    }

    public int getPaddingTop() {
        return this.marginInsets.top;
    }

    public int getPaddingBottom() {
        return this.paddingInsets.bottom;
    }

    public int getBorderWidth() {
        return this.getWidth() - this.getMarginLeft() - this.getMarginRight();
    }

    public int getBorderHeight() {
        return this.getHeight() - this.getMarginTop() - this.getMarginBottom();
    }

    public int getInsetsLeft() {
        return this.marginInsets.left + this.pageObjectBorder.getLeftInset() + this.paddingInsets.left;
    }

    public int getInsetsRight() {
        return this.marginInsets.right + this.pageObjectBorder.getRightInset() + this.paddingInsets.right;
    }

    public int getInsetsTop() {
        return this.marginInsets.top + this.pageObjectBorder.getTopInset() + this.paddingInsets.top;
    }

    public int getInsetsBottom() {
        return this.marginInsets.bottom + this.pageObjectBorder.getBottomInset() + this.paddingInsets.bottom;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public void setWidth(int width) {
        if (this.bounds.width != width) {
            this.bounds.width = width;
        }
    }

    public final int getHeight() {
        return this.bounds.height;
    }

    public void setHeight(int height) {
        if (this.bounds.height != height) {
            this.bounds.height = height;
        }
    }

    public int getContentWidth() {
        return this.getWidth() - this.getInsetsLeft() - this.getInsetsRight();
    }

    public int getContentHeight() {
        return this.getHeight() - this.getInsetsTop() - this.getInsetsBottom();
    }

    public Dimension getSize() {
        return new Dimension(this.bounds.getSize());
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public Rectangle getAbsoluteBounds() {
        Rectangle absoluteBounds = new Rectangle(this.bounds);
        for (PageObject parent = this.getParent(); parent != null; parent = parent.getParent()) {
            absoluteBounds.translate(parent.getX(), parent.getY());
        }
        return absoluteBounds;
    }

    public boolean contains(int x, int y) {
        return this.bounds.contains(x, y);
    }

    public boolean contains(Point point) {
        return this.bounds.contains(point);
    }

    public void invalidateLayout() {
        if (this.parent != null) {
            this.parent.invalidateLayout();
        }
    }

    public abstract void layout(FontRenderContext var1);

    public final void handleMouseMoved(MouseEvent event) {
        if (this.bounds.contains(event.getPoint())) {
            this.setMouseOver(true);
            this.doHandleMouseMoved(event);
            event.translatePoint(-this.getX(), -this.getY());
            for (PageObject child : this.getChildren()) {
                child.handleMouseMoved(event);
            }
            event.translatePoint(this.getX(), this.getY());
        } else {
            this.setMouseOver(false);
        }
    }

    protected void doHandleMouseEntered(MouseEvent e) {
    }

    protected void doHandleMouseExited(MouseEvent e) {
    }

    public final List<LinkBox> getLinks() {
        ArrayList<LinkBox> result = new ArrayList<LinkBox>();
        for (PageObject childPageObject : this.children) {
            if (childPageObject instanceof LinkBox) {
                LinkBox childLinkBox = (LinkBox)childPageObject;
                LinkBox translatedLinkBox = childLinkBox.translate(this.getX(), this.getY());
                result.add(translatedLinkBox);
                continue;
            }
            List<LinkBox> childLinks = childPageObject.getLinks();
            for (LinkBox childLinkBox : childLinks) {
                result.add(childLinkBox.translate(this.getX(), this.getY()));
            }
        }
        return result;
    }

    public final void draw(Graphics2D g2) {
        if (!g2.getClip().intersects(this.getBounds())) {
            return;
        }
        this.requestPaintContent(g2);
        for (PageObject pageObject : this.children) {
            pageObject.draw(g2);
        }
        g2.translate(this.getMarginLeft(), this.getMarginTop());
        this.pageObjectBorder.drawBorder(g2, this.getBorderWidth(), this.getBorderHeight(), this);
        g2.translate(-this.getMarginLeft(), -this.getMarginTop());
        g2.translate(-this.getX(), -this.getY());
    }

    private void requestPaintContent(Graphics2D g2) {
        int graphicsXOffset = this.getX() + this.getInsetsLeft();
        int graphicsYOffset = this.getY() + this.getInsetsTop();
        g2.translate(graphicsXOffset, graphicsYOffset);
        this.paintContent(g2);
        g2.translate(-graphicsXOffset, -graphicsYOffset);
        g2.translate(this.getX(), this.getY());
    }

    private void drawDebugBounds(Graphics2D g2) {
        Color oldColor = g2.getColor();
        int index = this.getDepth() % colors.length;
        g2.setColor(colors[index]);
        g2.draw(this.bounds);
        g2.drawLine(this.getX(), this.getY() + this.getHeight() / 2, this.getX() + this.getInsetsLeft(), this.getY() + this.getHeight() / 2);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{5.0f, 5.0f}, 0.0f));
        g2.drawRect(this.getX() + this.getInsetsLeft(), this.getY() + this.getInsetsTop(), this.getContentWidth(), this.getContentHeight());
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
    }

    private int getDepth() {
        PageObject parent = this.getParent();
        int depth = 0;
        while (parent != null) {
            parent = parent.getParent();
            ++depth;
        }
        return depth;
    }

    public final void handleMouseReleased(MouseEvent event) {
        if (this.contains(event.getX(), event.getY())) {
            this.doMouseReleased(event);
            event.translatePoint(this.getX(), this.getY());
            for (PageObject childPageObject : this.getChildren()) {
                if (!childPageObject.contains(event.getPoint())) continue;
                childPageObject.handleMouseReleased(event);
            }
            event.translatePoint(-this.getX(), -this.getY());
        }
    }

    protected void doMouseReleased(MouseEvent event) {
    }

    protected void doHandleMouseMoved(MouseEvent event) {
    }

    protected abstract void paintContent(Graphics2D var1);

    public PageObject getDeepestPageObjectAt(Point pt) {
        return this.getDeepestPageObjectOfClassAt(PageObject.class, pt);
    }

    public <T extends PageObject> T getDeepestPageObjectOfClassAt(Class<T> cls, Point pt) {
        PageObject result = null;
        if (this.bounds.contains(pt)) {
            if (cls.isInstance(this)) {
                result = (PageObject)cls.cast(this);
            }
            pt.translate(-this.getX(), -this.getY());
            for (PageObject childPageObject : this.children) {
                PageObject o = childPageObject.getDeepestPageObjectAt(pt);
                if (o == null || !cls.isInstance(o)) continue;
                result = (PageObject)cls.cast(o);
            }
            pt.translate(this.getX(), this.getY());
        }
        return (T)result;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    private void setMouseOver(boolean b) {
        this.mouseOver = b;
        if (!b) {
            for (PageObject child : this.children) {
                child.setMouseOver(false);
            }
        }
    }
}

