/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.protege.editor.owl.ui.renderer.layout.LinkBox;
import org.protege.editor.owl.ui.renderer.layout.LinkManager;
import org.protege.editor.owl.ui.renderer.layout.Page;
import org.protege.editor.owl.ui.renderer.layout.PageCache;
import org.protege.editor.owl.ui.renderer.layout.PageCacheKey;

public abstract class PageCellRenderer
extends JPanel
implements ListCellRenderer,
TableCellRenderer {
    private PageCache pageCache = new PageCache();
    private JComponent component;
    private LinkManager manager = new LinkManager();
    private Page page;

    public PageCellRenderer() {
        this.setOpaque(false);
    }

    protected Object getValueKey(Object value) {
        return value;
    }

    private PageCacheKey getPageCacheKey(Object value, boolean isSelected, boolean hasFocus) {
        return new PageCacheKey(this.getValueKey(value), isSelected, hasFocus);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int width;
        this.manager.setComponent(list);
        this.component = list;
        PageCacheKey pageCacheKey = this.getPageCacheKey(value, isSelected, cellHasFocus);
        this.page = this.pageCache.getPage(pageCacheKey);
        Graphics2D graphics = (Graphics2D)list.getGraphics();
        if (this.page == null) {
            this.page = new Page();
            if (pageCacheKey != null) {
                this.pageCache.put(pageCacheKey, this.page);
            }
            this.fillPage(this.page, list, value, index, isSelected, cellHasFocus);
            width = this.getMaxAvailablePageWidth(list, value, index, isSelected, cellHasFocus);
            this.page.setWidth(width);
            if (list.getGraphics() != null) {
                this.page.layout(graphics.getFontRenderContext());
            }
        } else {
            width = this.getMaxAvailablePageWidth(list, value, index, isSelected, cellHasFocus);
            if (this.page.getWidth() != width) {
                this.page.setWidth(width);
                this.page.invalidateLayout();
                this.page.layout(graphics.getFontRenderContext());
            }
        }
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        int prefWidth = this.page.getWidth();
        int prefHeight = this.page.getHeight();
        this.setPreferredSize(new Dimension(prefWidth, prefHeight));
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.manager.setComponent(table);
        this.component = table;
        this.page = new Page();
        this.fillPage(this.page, table, value, isSelected, hasFocus, row, column);
        this.getMaxAvailablePageWidth(this.page, table, value, isSelected, hasFocus, row, column);
        Graphics2D graphics = (Graphics2D)table.getGraphics();
        if (table.getGraphics() != null) {
            this.page.layout(graphics.getFontRenderContext());
        }
        this.setPreferredSize(this.page.getSize());
        return this;
    }

    protected abstract void fillPage(Page var1, JList var2, Object var3, int var4, boolean var5, boolean var6);

    protected abstract int getMaxAvailablePageWidth(JList var1, Object var2, int var3, boolean var4, boolean var5);

    protected abstract void fillPage(Page var1, JTable var2, Object var3, boolean var4, boolean var5, int var6, int var7);

    protected abstract int getMaxAvailablePageWidth(Page var1, JTable var2, Object var3, boolean var4, boolean var5, int var6, int var7);

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.page.setLocation(this.getInsets().left, this.getInsets().top);
        Point mousePos = this.component.getMousePosition();
        if (mousePos != null) {
            int pageRelativeX = mousePos.x - this.page.getX() - this.getX();
            int pageRelativeY = mousePos.y - this.page.getY() - this.getY();
        }
        this.page.draw(g2);
        Rectangle clip = g.getClipBounds();
        clip.translate(this.getX(), this.getY());
        this.manager.clear(clip);
        this.manager.setCurrentPage(this.page, this.getX(), this.getY());
        for (LinkBox pageLink : this.page.getLinks()) {
            this.manager.add(pageLink.translate(this.getX(), this.getY()));
        }
    }
}

