/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.conf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ui.preferences.PreferencesPanelLayoutManager;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.plugin.RendererPlugin;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class RendererPreferencesPanel
extends OWLPreferencesPanel {
    private static final Logger logger = Logger.getLogger(RendererPreferencesPanel.class);
    private Map<JRadioButton, RendererPlugin> buttonToRendererMap = new LinkedHashMap<JRadioButton, RendererPlugin>();
    private JList annotationPropertiesList;
    private JCheckBox highlightAOStatementsCheckBox;
    private JCheckBox showHyperlinksCheckBox;
    private JCheckBox highlightKeyWordsCheckBox;
    private JCheckBox useThatAsSynonymForAndCheckBox;
    private JSpinner fontSizeSpinner;
    private JButton configureButton;
    private RendererPlugin originalRendererPlugin;
    private boolean dirty = false;

    public void applyChanges() {
        OWLRendererPreferences prefs = OWLRendererPreferences.getInstance();
        prefs.setHighlightActiveOntologyStatements(this.highlightAOStatementsCheckBox.isSelected());
        prefs.setRenderHyperlinks(this.showHyperlinksCheckBox.isSelected());
        prefs.setHighlightKeyWords(this.highlightKeyWordsCheckBox.isSelected());
        prefs.setUseThatKeyword(this.useThatAsSynonymForAndCheckBox.isSelected());
        prefs.setFontSize((Integer)this.fontSizeSpinner.getValue());
        if (this.isDirty()) {
            RendererPlugin plugin = this.getSelectedRendererPlugin();
            try {
                prefs.setRendererPlugin(plugin);
                OWLModelManagerEntityRenderer ren = plugin.newInstance();
                this.getOWLModelManager().refreshRenderer();
            }
            catch (Exception e) {
                throw new OWLRuntimeException((Throwable)e);
            }
        }
        this.getOWLEditorKit().getWorkspace().refreshComponents();
    }

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        OWLRendererPreferences prefs = OWLRendererPreferences.getInstance();
        Box holderBox = new Box(1);
        this.add(holderBox, "North");
        holderBox.add(this.createRendererSelectionPanel());
        this.highlightAOStatementsCheckBox = new JCheckBox("Highlight active ontology statements", prefs.isHighlightActiveOntologyStatements());
        this.showHyperlinksCheckBox = new JCheckBox("Show hyperlinks in components that support them", prefs.isRenderHyperlinks());
        this.highlightKeyWordsCheckBox = new JCheckBox("Highlight keywords", prefs.isHighlightKeyWords());
        this.useThatAsSynonymForAndCheckBox = new JCheckBox("Use the 'that' keyword as a synonym for the 'and' keyword", prefs.isUseThatKeyword());
        Box optBox = new Box(1);
        optBox.setAlignmentX(0.0f);
        optBox.setBorder(ComponentFactory.createTitledBorder((String)"Appearance"));
        optBox.add(this.highlightAOStatementsCheckBox);
        optBox.add(this.showHyperlinksCheckBox);
        optBox.add(this.highlightKeyWordsCheckBox);
        optBox.add(this.useThatAsSynonymForAndCheckBox);
        optBox.add(Box.createVerticalStrut(4));
        holderBox.add(optBox);
        JPanel fontSizePanel = new JPanel();
        PreferencesPanelLayoutManager man = new PreferencesPanelLayoutManager((JComponent)fontSizePanel);
        fontSizePanel.setLayout((LayoutManager)man);
        fontSizePanel.setBorder(ComponentFactory.createTitledBorder((String)"Font"));
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel(prefs.getFontSize(), 1, 120, 1));
        fontSizePanel.add("Font size", this.fontSizeSpinner);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        ArrayList<String> fontNames = new ArrayList<String>();
        for (Font f : fonts) {
            fontNames.add(f.getName());
        }
        fontSizePanel.add(new JButton(new AbstractAction("Reset font"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RendererPreferencesPanel.this.resetFont();
            }
        }));
        holderBox.add(fontSizePanel);
    }

    protected void resetFont() {
        OWLRendererPreferences prefs = OWLRendererPreferences.getInstance();
        prefs.setFontSize(12);
        this.fontSizeSpinner.setValue(12);
    }

    private Component createRendererSelectionPanel() {
        OWLRendererPreferences prefs = OWLRendererPreferences.getInstance();
        for (RendererPlugin plugin : prefs.getRendererPlugins()) {
            this.addRenderer(plugin.getName(), plugin);
        }
        Box box = new Box(1);
        box.setBorder(ComponentFactory.createTitledBorder((String)"Entity rendering"));
        ButtonGroup bg = new ButtonGroup();
        for (JRadioButton button : this.buttonToRendererMap.keySet()) {
            bg.add(button);
            box.add(button);
        }
        box.add(Box.createVerticalStrut(4));
        JPanel optsPanel = new JPanel();
        optsPanel.setLayout(new BoxLayout(optsPanel, 2));
        optsPanel.setBorder(BorderFactory.createEmptyBorder(0, 50, 0, 0));
        optsPanel.setAlignmentX(0.0f);
        this.configureButton = new JButton(new AbstractAction("Configure..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                RendererPlugin plugin = RendererPreferencesPanel.this.getSelectedRendererPlugin();
                try {
                    if (plugin != null && plugin.newInstance().configure(RendererPreferencesPanel.this.getOWLEditorKit())) {
                        RendererPreferencesPanel.this.dirty = true;
                    }
                }
                catch (Exception cnfe) {
                    ProtegeApplication.getErrorLog().logError((Throwable)cnfe);
                }
            }
        });
        optsPanel.add(this.configureButton);
        box.add(optsPanel);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RendererPreferencesPanel.this.updateRendererButtons();
            }
        };
        for (JRadioButton button : this.buttonToRendererMap.keySet()) {
            button.addChangeListener(l);
        }
        this.updateRendererButtons();
        return box;
    }

    private void addRenderer(String label, RendererPlugin plugin) {
        RendererPlugin currentPlugin = OWLRendererPreferences.getInstance().getRendererPlugin();
        JRadioButton button = new JRadioButton(label, plugin.equals(currentPlugin));
        this.buttonToRendererMap.put(button, plugin);
    }

    private void updateRendererButtons() {
        RendererPlugin plugin = this.getSelectedRendererPlugin();
        if (plugin != null) {
            try {
                this.configureButton.setEnabled(plugin.newInstance().isConfigurable());
            }
            catch (Exception e) {
                ProtegeApplication.getErrorLog().logError((Throwable)e);
                this.configureButton.setEnabled(false);
            }
        }
    }

    public void dispose() {
    }

    public boolean isDirty() {
        return this.dirty || this.getSelectedRendererPlugin() != null && !this.getSelectedRendererPlugin().equals(this.originalRendererPlugin);
    }

    public RendererPlugin getSelectedRendererPlugin() {
        for (JRadioButton button : this.buttonToRendererMap.keySet()) {
            if (!button.isSelected()) continue;
            return this.buttonToRendererMap.get(button);
        }
        return null;
    }
}

