/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.protege.editor.owl.ui.renderer.OWLEntityIcon;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;

public class OWLPropertyIcon
extends OWLEntityIcon {
    private Color iconColor;

    public OWLPropertyIcon(Color iconColor) {
        super(OWLEntityIcon.SizeBias.EVEN);
        this.iconColor = iconColor;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int xOffset = x + this.getPadding();
        int yOffset = y + this.getPadding();
        int width = this.getIconWidth() - 2 * this.getPadding();
        int height = this.getIconHeight() - 2 * this.getPadding();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g2.getColor();
        g2.setColor(Color.GRAY);
        int fillHeight = 2 * height / 3;
        int y1 = yOffset + height / 6 + OWLRendererPreferences.getInstance().getFontSize() / 10;
        g2.fillRoundRect(xOffset, y1, width, fillHeight, 4, 4);
        g2.setColor(this.iconColor);
        g2.fillRoundRect(xOffset + 1, y1 + 1, width - 2, fillHeight - 2, 4, 4);
        g2.setColor(oldColor);
    }
}

