/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.protege.editor.owl.ui.renderer.AbstractOWLEntityRenderer;
import org.protege.editor.owl.ui.renderer.prefix.PrefixBasedRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.PrefixManager;

public class OWLEntityQNameRenderer
extends AbstractOWLEntityRenderer
implements PrefixBasedRenderer {
    private PrefixManager prefixManager;

    @Override
    public void initialise() {
        this.prefixManager = PrefixUtilities.getPrefixOWLOntologyFormat(this.getOWLModelManager());
    }

    @Override
    public void ontologiesChanged() {
        this.initialise();
    }

    @Override
    public String render(IRI iri) {
        try {
            String s = this.prefixManager.getPrefixIRI(iri);
            if (s != null) {
                if (s.startsWith(":")) {
                    s = s.substring(1);
                }
                return s;
            }
            return iri.toQuotedString();
        }
        catch (Exception e) {
            return "<Error! " + e.getMessage() + ">";
        }
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public boolean configure(OWLEditorKit eKit) {
        throw new IllegalStateException("This renderer is not configurable");
    }

    @Override
    protected void disposeRenderer() {
    }
}

