/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.protege.editor.owl.ui.renderer.OWLEntityIcon;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;

public class OWLClassIcon
extends OWLEntityIcon {
    public static final Color COLOR = OWLSystemColors.getOWLClassColor();
    private Type type;

    public OWLClassIcon(Type type) {
        super(OWLEntityIcon.SizeBias.EVEN);
        this.type = type;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.translate(x + this.getPadding(), y + this.getPadding());
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        g.setColor(Color.LIGHT_GRAY);
        int size = this.getSize() - 2 * this.getPadding();
        g.fillOval(x, y, size, size);
        g.setColor(COLOR);
        g.fillOval(x + 1, y + 1, size - 2, size - 2);
        if (this.type.equals((Object)Type.DEFINED)) {
            g2.setColor(Color.WHITE);
            int centreSize = (int)Math.sqrt(size / 2 * size / 2);
            int boxWidth = centreSize / 2 * 2;
            int boxHeight = centreSize / 5 * 5;
            int boxX = (size - boxWidth) / 2;
            int boxY = (size - boxHeight) / 2;
            g2.fillRect(x + boxX, y + boxY, boxWidth, boxHeight);
            int stripeHeight = boxHeight / 5;
            g2.setColor(COLOR);
            g2.fillRect(x + boxX, y + boxY + stripeHeight, boxWidth, stripeHeight);
            g2.fillRect(x + boxX, y + boxY + stripeHeight * 3, boxWidth, stripeHeight);
        }
        g.setColor(oldColor);
        g.translate(-x - this.getPadding(), -y - this.getPadding());
    }

    public static enum Type {
        PRIMITIVE,
        DEFINED;

    }
}

