/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Color;
import java.awt.Insets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.coode.string.EscapeUtils;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.list.AbstractAnnotationsList;
import org.protege.editor.owl.ui.renderer.layout.HTTPLink;
import org.protege.editor.owl.ui.renderer.layout.LinkSpan;
import org.protege.editor.owl.ui.renderer.layout.OWLEntityLink;
import org.protege.editor.owl.ui.renderer.layout.Page;
import org.protege.editor.owl.ui.renderer.layout.PageCellRenderer;
import org.protege.editor.owl.ui.renderer.layout.Paragraph;
import org.protege.editor.owl.ui.renderer.layout.Span;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class OWLAnnotationCellRenderer2
extends PageCellRenderer {
    public static final Color ANNOTATION_PROPERTY_FOREGROUND = new Color(65, 108, 226);
    private OWLEditorKit editorKit;
    private Pattern URL_PATTERN = Pattern.compile("\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\\b");
    private OWLOntology ontology;

    public OWLAnnotationCellRenderer2(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
    }

    public void setReferenceOntology(OWLOntology ontology) {
        this.ontology = ontology;
    }

    public void clearReferenceOntology() {
        this.ontology = null;
    }

    public boolean isReferenceOntologyActive() {
        return this.ontology != null && this.ontology.equals(this.editorKit.getOWLModelManager().getActiveOntology());
    }

    @Override
    protected Object getValueKey(Object value) {
        return this.extractOWLAnnotationFromCellValue(value);
    }

    @Override
    protected void fillPage(Page page, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color foreground = isSelected ? table.getSelectionForeground() : table.getForeground();
        Color background = isSelected ? table.getSelectionBackground() : table.getBackground();
        this.renderCellValue(page, value, foreground, background, isSelected);
    }

    @Override
    protected int getMaxAvailablePageWidth(Page page, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return table.getColumnModel().getColumn(column).getWidth();
    }

    @Override
    protected void fillPage(Page page, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color foreground = isSelected ? list.getSelectionForeground() : list.getForeground();
        Color background = isSelected ? list.getSelectionBackground() : list.getBackground();
        this.renderCellValue(page, value, foreground, background, isSelected);
    }

    @Override
    protected int getMaxAvailablePageWidth(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Insets insets = list.getInsets();
        int componentWidth = list.getWidth();
        JViewport vp = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, list);
        if (vp != null) {
            componentWidth = vp.getViewRect().width;
        }
        return componentWidth - list.getInsets().left - list.getInsets().right - insets.left + insets.right - 20;
    }

    private void renderCellValue(Page page, Object value, Color foreground, Color background, boolean isSelected) {
        OWLAnnotation annotation = this.extractOWLAnnotationFromCellValue(value);
        if (annotation != null) {
            this.renderAnnotationProperty(page, annotation, foreground, background, isSelected);
            this.renderAnnotationValue(page, annotation, foreground, background, isSelected);
        }
        page.setMargin(2);
        page.setMarginBottom(6);
    }

    protected OWLAnnotation extractOWLAnnotationFromCellValue(Object value) {
        OWLAnnotation annotation = null;
        if (value instanceof AbstractAnnotationsList.AnnotationsListItem) {
            annotation = ((AbstractAnnotationsList.AnnotationsListItem)value).getAnnotation();
        } else if (value instanceof OWLAnnotation) {
            annotation = (OWLAnnotation)value;
        }
        return annotation;
    }

    private void applyGlobalFormattingToAnnotationValueParagraphs(List<Paragraph> valueRenderingParagraphs) {
        for (Paragraph paragraph : valueRenderingParagraphs) {
            paragraph.setTabCount(0);
            paragraph.setMarginBottom(2);
        }
    }

    private void renderAnnotationProperty(Page page, OWLAnnotation annotation, Color defaultForeground, Color defaultBackground, boolean isSelected) {
        OWLAnnotationProperty property = annotation.getProperty();
        String rendering = this.editorKit.getOWLModelManager().getRendering((OWLObject)property);
        Paragraph paragraph = page.addParagraph(rendering);
        Color foreground = this.getAnnotationPropertyForeground(defaultForeground, isSelected);
        paragraph.setForeground(foreground);
        if (annotation.getValue() instanceof OWLLiteral) {
            OWLLiteral literalValue = (OWLLiteral)annotation.getValue();
            paragraph.append("    ", foreground);
            this.appendTag(paragraph, literalValue, foreground, isSelected);
        }
        paragraph.setMarginBottom(4);
    }

    private Color getAnnotationPropertyForeground(Color defaultForeground, boolean isSelected) {
        return isSelected ? defaultForeground : ANNOTATION_PROPERTY_FOREGROUND;
    }

    private List<Paragraph> renderAnnotationValue(final Page page, OWLAnnotation annotation, final Color defaultForeground, final Color defaultBackground, final boolean isSelected) {
        OWLAnnotationValue annotationValue = annotation.getValue();
        List paragraphs = (List)annotationValue.accept((OWLAnnotationValueVisitorEx)new OWLAnnotationValueVisitorEx<List<Paragraph>>(){

            public List<Paragraph> visit(IRI iri) {
                return OWLAnnotationCellRenderer2.this.renderIRI(page, iri, defaultForeground, defaultBackground, isSelected, OWLAnnotationCellRenderer2.this.hasFocus());
            }

            public List<Paragraph> visit(OWLAnonymousIndividual individual) {
                return OWLAnnotationCellRenderer2.this.renderAnonymousIndividual(page, individual);
            }

            public List<Paragraph> visit(OWLLiteral literal) {
                return OWLAnnotationCellRenderer2.this.renderLiteral(page, literal, defaultForeground, defaultBackground, isSelected);
            }
        });
        this.applyGlobalFormattingToAnnotationValueParagraphs(paragraphs);
        return paragraphs;
    }

    private List<Paragraph> renderIRI(Page page, IRI iri, Color defaultForeground, Color defaultBackgound, boolean isSelected, boolean hasFocus) {
        OWLModelManager modelManager = this.editorKit.getOWLModelManager();
        Set<OWLEntity> entities = modelManager.getOWLEntityFinder().getEntities(iri);
        List<Paragraph> paragraphs = entities.isEmpty() ? this.renderExternalIRI(page, iri) : this.renderEntities(page, entities);
        return paragraphs;
    }

    private boolean isLinkableAddress(IRI iri) {
        String scheme = iri.getScheme();
        return scheme != null && scheme.startsWith("http");
    }

    private List<Paragraph> renderExternalIRI(Page page, IRI iri) {
        Paragraph paragraph = this.isLinkableAddress(iri) ? page.addParagraph(iri.toString(), new HTTPLink(iri.toURI())) : page.addParagraph(iri.toString());
        return Arrays.asList(paragraph);
    }

    private List<Paragraph> renderEntities(Page page, Set<OWLEntity> entities) {
        ArrayList<Paragraph> paragraphs = new ArrayList<Paragraph>();
        for (OWLEntity entity : entities) {
            Icon icon = this.getIcon((OWLObject)entity);
            OWLModelManager modelManager = this.editorKit.getOWLModelManager();
            Paragraph paragraph = new Paragraph(modelManager.getRendering((OWLObject)entity), new OWLEntityLink(this.editorKit, entity));
            paragraph.setIcon(icon);
            page.add(paragraph);
            paragraphs.add(paragraph);
        }
        return paragraphs;
    }

    private Icon getIcon(OWLObject entity) {
        return this.editorKit.getOWLWorkspace().getOWLIconProvider().getIcon(entity);
    }

    private List<Paragraph> renderLiteral(Page page, OWLLiteral literal, Color foreground, Color background, boolean isSelected) {
        String rendering = EscapeUtils.unescapeString((String)literal.getLiteral()).trim();
        ArrayList<Paragraph> result = new ArrayList<Paragraph>();
        if (rendering.length() > 0) {
            List<LinkSpan> linkSpans = this.extractLinks(rendering);
            Paragraph literalParagraph = new Paragraph(rendering, linkSpans);
            literalParagraph.setForeground(foreground);
            page.add(literalParagraph);
            result.add(literalParagraph);
            Paragraph tagParagraph = literalParagraph;
            tagParagraph.append("    ", foreground);
            page.add(tagParagraph);
            result.add(tagParagraph);
            tagParagraph.setMarginTop(2);
            tagParagraph.setTabCount(2);
        }
        return result;
    }

    private void appendTag(Paragraph tagParagraph, OWLLiteral literal, Color foreground, boolean isSelected) {
        Color tagValueColor;
        Color tagColor = isSelected ? foreground : Color.GRAY;
        Color color = tagValueColor = isSelected ? foreground : Color.GRAY;
        if (literal.hasLang()) {
            tagParagraph.append("[language: ", tagColor);
            tagParagraph.append(literal.getLang(), tagValueColor);
            tagParagraph.append("]", tagColor);
        } else if (!literal.isRDFPlainLiteral()) {
            tagParagraph.append("[type: ", tagColor);
            tagParagraph.append(this.editorKit.getOWLModelManager().getRendering((OWLObject)literal.getDatatype()), tagValueColor);
            tagParagraph.append("]", tagColor);
        }
    }

    private List<LinkSpan> extractLinks(String s) {
        Matcher matcher = this.URL_PATTERN.matcher(s);
        ArrayList<LinkSpan> result = new ArrayList<LinkSpan>();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String url = s.substring(start, end);
            try {
                result.add(new LinkSpan(new HTTPLink(new URI(url)), new Span(start, end)));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private List<Paragraph> renderAnonymousIndividual(Page page, OWLAnonymousIndividual individual) {
        String rendering = this.editorKit.getOWLModelManager().getRendering((OWLObject)individual);
        Paragraph paragraph = page.addParagraph(rendering);
        paragraph.setIcon(this.getIcon((OWLObject)individual));
        return Arrays.asList(paragraph);
    }
}

