/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.rename;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;

public class RenameEntityPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(RenameEntityPanel.class);
    private static final String AUTO_RENAME_PUNS = "AUTO_RENAME_PUNS";
    private OWLEditorKit owlEditorKit;
    private OWLEntity owlEntity;
    private JTextField textField;
    private JCheckBox showFullURICheckBox;
    private JCheckBox renamePunsCheckBox;
    private static boolean showFullURI = false;
    private boolean renamePuns;

    public RenameEntityPanel(OWLEditorKit owlEditorKit, OWLEntity owlEntity) {
        this.owlEditorKit = owlEditorKit;
        this.owlEntity = owlEntity;
        this.renamePuns = RenameEntityPanel.isAutoRenamePuns();
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout(3, 3));
        this.textField = new JTextField(50);
        this.renamePunsCheckBox = new JCheckBox("Change all entities with this URI", this.renamePuns);
        this.renamePunsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameEntityPanel.this.renamePuns = RenameEntityPanel.this.renamePunsCheckBox.isSelected();
            }
        });
        this.showFullURICheckBox = new JCheckBox("Show full IRI", showFullURI);
        this.showFullURICheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameEntityPanel.this.updateTextField();
            }
        });
        JPanel checkBoxHolderPanel = new JPanel(new BorderLayout());
        checkBoxHolderPanel.add((Component)this.renamePunsCheckBox, "West");
        checkBoxHolderPanel.add((Component)this.showFullURICheckBox, "East");
        this.add((Component)this.textField, "North");
        this.add((Component)checkBoxHolderPanel, "South");
        this.updateTextField();
    }

    private String getFragment() {
        String fragment = this.owlEntity.getIRI().getFragment();
        if (fragment != null) {
            return fragment;
        }
        return "";
    }

    private String getBase() {
        String fragment = this.getFragment();
        if (fragment != null) {
            try {
                String uriString = URLDecoder.decode(this.owlEntity.getIRI().toString(), "utf-8");
                return uriString.substring(0, uriString.length() - fragment.length());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    private void updateTextField() {
        showFullURI = this.showFullURICheckBox.isSelected();
        if (showFullURI) {
            String enteredFragment = this.textField.getText();
            if (enteredFragment.length() > 0) {
                this.textField.setText(this.getBase() + enteredFragment);
            } else {
                this.textField.setText(this.getBase() + this.getFragment());
            }
        } else {
            try {
                URI uri = new URI(this.textField.getText());
                String fragment = uri.getFragment();
                if (fragment != null) {
                    this.textField.setText(fragment);
                } else {
                    this.textField.setText(this.getFragment());
                }
            }
            catch (URISyntaxException e) {
                this.textField.setText(this.getFragment());
            }
        }
    }

    public IRI getIRI() {
        try {
            String newName = this.textField.getText().trim().replaceAll(" ", "_");
            if (this.showFullURICheckBox.isSelected()) {
                return IRI.create((URI)new URI(newName));
            }
            return IRI.create((URI)new URI(this.getBase() + newName));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public boolean getRenamePuns() {
        return this.renamePuns;
    }

    public static boolean isAutoRenamePuns() {
        return PreferencesManager.getInstance().getApplicationPreferences(RenameEntityPanel.class).getBoolean(AUTO_RENAME_PUNS, false);
    }

    public static IRI showDialog(OWLEditorKit owlEditorKit, OWLEntity entity) {
        RenameEntityPanel panel = new RenameEntityPanel(owlEditorKit, entity);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (JOptionPaneEx.showConfirmDialog(null, (String)"Change entity URI", (JComponent)panel, (int)-1, (int)2, (JComponent)panel.textField) == 0) {
            PreferencesManager.getInstance().getApplicationPreferences(RenameEntityPanel.class).putBoolean(AUTO_RENAME_PUNS, panel.getRenamePuns());
            return panel.getIRI();
        }
        return null;
    }
}

