/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class PrefixMapperTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -5098097390890500539L;
    private static final Logger LOGGER = Logger.getLogger(PrefixMapperTableModel.class);
    private List<String> prefixes;
    private Map<String, String> prefixValueMap;
    private PrefixOWLOntologyFormat prefixManager;
    private boolean changed = false;

    public PrefixMapperTableModel(PrefixOWLOntologyFormat prefixManager) {
        this.prefixManager = prefixManager;
        this.prefixValueMap = new HashMap<String, String>();
        this.prefixes = new ArrayList<String>();
        this.refill();
    }

    public void refill() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Clearing changed flag because of a refill operation");
        }
        this.changed = false;
        this.prefixes.clear();
        this.prefixValueMap.clear();
        for (Map.Entry prefixName2PrefixEntry : this.prefixManager.getPrefixName2PrefixMap().entrySet()) {
            String prefixName = (String)prefixName2PrefixEntry.getKey();
            String prefix = (String)prefixName2PrefixEntry.getValue();
            prefixName = prefixName.substring(0, prefixName.length() - 1);
            this.prefixValueMap.put(prefixName, prefix);
        }
        this.prefixes.addAll(this.prefixValueMap.keySet());
        Collections.sort(this.prefixes);
        this.fireTableDataChanged();
    }

    public int getIndexOfPrefix(String prefix) {
        return this.prefixes.indexOf(prefix);
    }

    public int addMapping(String prefix, String value) {
        boolean bl = this.changed = this.changed || value != null && value.length() != 0;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("adding mapping " + prefix + " -> " + value + " changed = " + this.changed));
        }
        this.prefixes.add(prefix);
        Collections.sort(this.prefixes);
        this.prefixValueMap.put(prefix, value);
        this.fireTableDataChanged();
        return this.prefixes.indexOf(prefix);
    }

    public void removeMapping(String prefix) {
        this.prefixes.remove(prefix);
        String prefixValue = this.prefixValueMap.remove(prefix);
        boolean bl = this.changed || prefixValue != null & prefixValue.length() != 0 ? true : (this.changed = false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("removing mapping " + prefix + " -> " + prefixValue + " changed = " + this.changed));
        }
        this.fireTableDataChanged();
    }

    public boolean commitPrefixes() {
        if (this.changed) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"committing prefix changes and clearing changed flag");
            }
            this.prefixManager.clearPrefixes();
            for (Map.Entry<String, String> prefixName2PrefixEntry : this.prefixValueMap.entrySet()) {
                String prefixName = prefixName2PrefixEntry.getKey();
                String prefix = prefixName2PrefixEntry.getValue();
                if (prefix == null || prefix.length() == 0) continue;
                this.prefixManager.setPrefix(prefixName, prefix);
            }
            this.changed = false;
            return true;
        }
        return false;
    }

    public void sortTable() {
        Collections.sort(this.prefixes);
    }

    @Override
    public String getColumnName(int column) {
        switch (Column.values()[column]) {
            case PREFIX_NAME: {
                return "Prefix";
            }
            case PREFIX: {
                return "Value";
            }
        }
        throw new UnsupportedOperationException("Programmer error: missed a case");
    }

    @Override
    public int getRowCount() {
        return this.prefixes.size();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !PrefixUtilities.isStandardPrefix(this.prefixes.get(rowIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String prefix = this.prefixes.get(rowIndex);
        switch (Column.values()[columnIndex]) {
            case PREFIX_NAME: {
                return prefix;
            }
            case PREFIX: {
                return this.prefixValueMap.get(prefix);
            }
        }
        throw new UnsupportedOperationException("Programmer error: missed a case");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String currentPrefixName = (String)this.getValueAt(rowIndex, Column.PREFIX_NAME.ordinal());
        switch (Column.values()[columnIndex]) {
            case PREFIX_NAME: {
                String newPrefix = aValue.toString();
                if (this.prefixes.contains(newPrefix)) break;
                this.prefixes.remove(currentPrefixName);
                this.prefixes.add(newPrefix);
                Collections.sort(this.prefixes);
                String prefixValue = this.prefixValueMap.remove(currentPrefixName);
                this.prefixValueMap.put(newPrefix, prefixValue);
                boolean bl = this.changed = this.changed || prefixValue != null && prefixValue.length() != 0;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Changed the name associated with the prefix " + prefixValue + " from " + currentPrefixName + " to " + newPrefix + " changed = " + this.changed));
                }
                this.fireTableDataChanged();
                break;
            }
            case PREFIX: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Changing the value associated with the prefix " + currentPrefixName + " with a delete and an add."));
                }
                this.removeMapping(currentPrefixName);
                this.addMapping(currentPrefixName, aValue.toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Programmer error: missed a case");
            }
        }
    }

    public static enum Column {
        PREFIX_NAME,
        PREFIX;

    }
}

