/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import javax.swing.event.ChangeEvent;
import org.protege.editor.owl.ui.prefix.PrefixMapperTableModel;
import org.protege.editor.owl.ui.prefix.PrefixTableCellEditor;
import org.protege.editor.owl.ui.table.BasicOWLTable;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class PrefixMapperTable
extends BasicOWLTable {
    private static final long serialVersionUID = 7960180034430124925L;
    private PrefixOWLOntologyFormat prefixManager;

    public PrefixMapperTable(PrefixOWLOntologyFormat prefixManager) {
        super(new PrefixMapperTableModel(prefixManager));
        this.setShowGrid(true);
        this.setRowHeight(this.getRowHeight() + 3);
        this.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.getColumnModel().getColumn(1).setPreferredWidth(600);
        this.getColumnModel().getColumn(0).setCellEditor(new PrefixTableCellEditor());
        this.getColumnModel().getColumn(1).setCellEditor(new PrefixTableCellEditor());
        this.prefixManager = prefixManager;
    }

    public PrefixOWLOntologyFormat getPrefixMapperManager() {
        return this.prefixManager;
    }

    public void createAndEditRow() {
        String candidatePrefix;
        PrefixMapperTableModel model = this.getModel();
        int i = 0;
        while (true) {
            if (model.getIndexOfPrefix(candidatePrefix = "p" + i) < 0) break;
            ++i;
        }
        int index = model.addMapping(candidatePrefix, "");
        this.setRowSelectionInterval(index, index);
        this.editCellAt(index, PrefixMapperTableModel.Column.PREFIX.ordinal());
    }

    @Override
    protected boolean isHeaderVisible() {
        return true;
    }

    @Override
    public PrefixMapperTableModel getModel() {
        return (PrefixMapperTableModel)super.getModel();
    }

    @Override
    public void editingStopped(ChangeEvent arg0) {
        int newRow;
        int editingColumn = this.getEditingColumn();
        String cellValue = (String)this.getCellEditor().getCellEditorValue();
        super.editingStopped(arg0);
        if (editingColumn == PrefixMapperTableModel.Column.PREFIX_NAME.ordinal() && (newRow = this.getModel().getIndexOfPrefix(cellValue)) >= 0) {
            this.setRowSelectionInterval(newRow, newRow);
            this.editCellAt(newRow, PrefixMapperTableModel.Column.PREFIX.ordinal());
            this.requestFocus();
        }
    }
}

