/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.move.byreference;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKit;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKitConfigurationPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.byreference.SelectSignaturePanel;
import org.protege.editor.owl.ui.ontology.wizard.move.common.SignatureDependentSelectionPreviewPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.common.SignatureSelection;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public class MoveAxiomsByReferenceKit
extends MoveAxiomsKit
implements SignatureSelection {
    private Set<OWLEntity> selectedEntities;
    private SelectSignaturePanel selectSignaturePanel;
    private SignatureDependentSelectionPreviewPanel selectPreviewPanel;

    @Override
    public List<MoveAxiomsKitConfigurationPanel> getConfigurationPanels() {
        ArrayList<MoveAxiomsKitConfigurationPanel> panels = new ArrayList<MoveAxiomsKitConfigurationPanel>();
        panels.add(this.selectSignaturePanel);
        panels.add(this.selectPreviewPanel);
        return panels;
    }

    @Override
    public Set<OWLAxiom> getAxioms(Set<OWLOntology> sourceOntologies) {
        return this.getAxioms(sourceOntologies, this.selectedEntities);
    }

    @Override
    public Set<OWLAxiom> getAxioms(Set<OWLOntology> ontologies, Set<OWLEntity> entities) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLEntity e : entities) {
            for (OWLOntology ont : ontologies) {
                result.addAll(ont.getReferencingAxioms(e));
                result.addAll(ont.getAnnotationAssertionAxioms((OWLAnnotationSubject)e.getIRI()));
            }
        }
        return result;
    }

    public void initialise() throws Exception {
        this.selectedEntities = new HashSet<OWLEntity>();
        this.selectSignaturePanel = new SelectSignaturePanel(this);
        this.selectPreviewPanel = new SignatureDependentSelectionPreviewPanel(this);
    }

    public void dispose() throws Exception {
    }

    @Override
    public Set<OWLEntity> getSignature() {
        return this.selectedEntities;
    }

    @Override
    public void setSignature(Set<OWLEntity> entities) {
        this.selectedEntities.clear();
        this.selectedEntities.addAll(entities);
    }
}

