/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.create;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.core.ui.wizard.AbstractWizardPanel;
import org.protege.editor.core.ui.wizard.Wizard;
import org.protege.editor.owl.ui.ontology.wizard.create.OntologyIDPanel;

public class PhysicalLocationPanel
extends AbstractWizardPanel {
    public static final String ID = PhysicalLocationPanel.class.getName();
    public static final String DEFAULT_LOCAL_BASE_KEY = "DEFAULT_LOCAL_BASE_KEY";
    public static final String RECENT_LOCATIONS_KEY = "RECENT_LOCATIONS_KEY";
    private JTextField locationField;
    private File locationBase;
    private JList recentLocations;
    private ListSelectionListener listSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                PhysicalLocationPanel.this.setBaseFromRecentLocationList();
            }
        }
    };

    public PhysicalLocationPanel(EditorKit editorKit) {
        super((Object)ID, "Physical Location", editorKit);
        Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.owl");
        String path = prefs.getString(DEFAULT_LOCAL_BASE_KEY, new File(new File(System.getProperty("user.home")), "ontologies").toString());
        this.locationBase = new File(path);
    }

    protected void createUI(JComponent parent) {
        parent.setLayout(new BorderLayout(10, 10));
        this.setInstructions("Please specify the file path that points to the location where your ontology will be saved to. (Click on a location in the 'recent locations' list to automatically select that location).");
        JPanel locationPanel = new JPanel(new BorderLayout(3, 3));
        this.locationField = new JTextField();
        this.locationField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                PhysicalLocationPanel.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                PhysicalLocationPanel.this.updateState();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
            }
        });
        JPanel locationFieldPanel = new JPanel(new BorderLayout(3, 3));
        locationFieldPanel.add((Component)this.locationField, "North");
        locationFieldPanel.add((Component)new JButton(new AbstractAction("Browse..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhysicalLocationPanel.this.browseForLocation();
            }
        }), "East");
        locationPanel.add(locationFieldPanel);
        JButton button = new JButton(new AbstractAction("Default base..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhysicalLocationPanel.this.setDefaultLocalBase();
            }
        });
        JPanel holder = new JPanel(new FlowLayout(2));
        holder.add(button);
        parent.add((Component)holder, "South");
        parent.add((Component)locationPanel, "North");
        this.recentLocations = new JList(new DefaultListModel());
        JPanel recentLocationsPanel = new JPanel(new BorderLayout(3, 3));
        recentLocationsPanel.add((Component)new JLabel("RecentLocations"), "North");
        recentLocationsPanel.add(ComponentFactory.createScrollPane((JComponent)this.recentLocations));
        parent.add(recentLocationsPanel);
        this.loadRecentLocations();
    }

    private void setBaseFromRecentLocationList() {
        File file = (File)this.recentLocations.getSelectedValue();
        if (file != null) {
            this.locationBase = file;
            this.locationField.setText(new File(file, this.getOntologyLocalName()).toString());
        }
    }

    private void browseForLocation() {
        HashSet<String> exts = new HashSet<String>();
        exts.add(".owl");
        exts.add(".rdf");
        File file = UIUtil.saveFile((Component)new JFrame(), (String)"Select a file", (String)"OWL File", exts, (String)this.getOntologyLocalName());
        if (file != null) {
            this.locationField.setText(file.toString());
        }
    }

    private void updateLocationField() {
        String name;
        String foldername = name = this.getOntologyLocalName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex != -1) {
            foldername = name.substring(0, dotIndex);
        }
        File f = new File(this.locationBase, foldername);
        f = new File(f, name);
        try {
            this.locationField.setText(f.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getOntologyLocalName() {
        int lastSlashIndex;
        Wizard wizard = this.getWizard();
        OntologyIDPanel IDPanel = (OntologyIDPanel)wizard.getModel().getPanel((Object)"ONTOLOGY_ID_PANEL");
        String uriString = "";
        if (IDPanel != null) {
            uriString = IDPanel.getOntologyID().getOntologyIRI().toString();
        }
        if ((lastSlashIndex = uriString.lastIndexOf("/")) == -1) {
            return uriString;
        }
        return uriString.substring(lastSlashIndex + 1, uriString.length());
    }

    public void displayingPanel() {
        this.updateLocationField();
        this.recentLocations.addListSelectionListener(this.listSelectionListener);
        this.locationField.requestFocus();
    }

    public void aboutToHidePanel() {
        super.aboutToHidePanel();
        this.recentLocations.removeListSelectionListener(this.listSelectionListener);
    }

    public void loadRecentLocations() {
        Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.owl");
        List list = new ArrayList();
        list = prefs.getStringList(RECENT_LOCATIONS_KEY, list);
        DefaultListModel<File> model = new DefaultListModel<File>();
        for (String s : list) {
            try {
                File file = new File(URI.create(s));
                if (!file.exists()) continue;
                model.add(0, file);
            }
            catch (Throwable t) {}
        }
        this.recentLocations.setModel(model);
        prefs.putStringList(RECENT_LOCATIONS_KEY, list);
    }

    public void storeRecentLocations() {
        Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.owl");
        ArrayList<String> list = new ArrayList<String>();
        DefaultListModel model = (DefaultListModel)this.recentLocations.getModel();
        if (this.getLocationURL() != null) {
            File file = new File(this.getLocationURL()).getParentFile();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!model.getElementAt(i).equals(file)) continue;
                model.remove(i);
                break;
            }
            model.add(0, file);
        }
        for (Object o : model.toArray()) {
            File file = (File)o;
            URI uri = file.toURI();
            list.add(uri.toString());
        }
        prefs.putStringList(RECENT_LOCATIONS_KEY, list);
    }

    protected void setDefaultLocalBase() {
        File folder = UIUtil.chooseFolder((Component)((Object)this), (String)"Please select a folder");
        if (folder != null) {
            this.locationBase = folder;
            Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.owl");
            prefs.putString(DEFAULT_LOCAL_BASE_KEY, this.locationBase.toString());
            this.updateLocationField();
        }
    }

    public URI getLocationURL() {
        File f = new File(this.locationField.getText());
        return f.toURI();
    }

    public Object getNextPanelDescriptor() {
        return "ONTOLOGY_FORMAT_PANEL";
    }

    public Object getBackPanelDescriptor() {
        return "ONTOLOGY_ID_PANEL";
    }

    public void aboutToDisplayPanel() {
        this.updateState();
    }

    private void updateState() {
        this.getWizard().setNextFinishButtonEnabled(this.isValidLocation());
    }

    private boolean isValidLocation() {
        File f = new File(this.locationField.getText());
        return f.getName() != null && f.getName().indexOf(".") > 0;
    }
}

