/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.location;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class PhysicalLocationTableModel
extends AbstractTableModel {
    private static final Logger logger = Logger.getLogger(PhysicalLocationTableModel.class);
    private OWLModelManager owlModelManager;
    private Map<OWLOntologyID, URI> uriMap;
    private List<OWLOntologyID> ontologyIDs;
    private static final String[] COLUMN_NAMES = new String[]{"Ontology", "Physical location"};

    public PhysicalLocationTableModel(OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
        this.uriMap = new TreeMap<OWLOntologyID, URI>();
        this.ontologyIDs = new ArrayList<OWLOntologyID>();
        this.refill();
    }

    public void dispose() {
    }

    public void refill() {
        this.uriMap.clear();
        this.ontologyIDs.clear();
        for (OWLOntology ont : this.owlModelManager.getOntologies()) {
            this.ontologyIDs.add(ont.getOntologyID());
            this.uriMap.put(ont.getOntologyID(), this.owlModelManager.getOntologyPhysicalURI(ont));
        }
    }

    @Override
    public int getRowCount() {
        return this.ontologyIDs.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        OWLOntologyID id = this.ontologyIDs.get(rowIndex);
        if (columnIndex == 0) {
            return id;
        }
        return this.uriMap.get(id);
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }
}

