/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.wizard.page;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.protege.editor.owl.ui.library.OntologyLibraryPanel;
import org.protege.editor.owl.ui.ontology.imports.wizard.GetImportsVisitor;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.protege.editor.owl.ui.ontology.imports.wizard.OntologyImportWizard;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.ImportConfirmationPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.OntologyImportPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.SelectImportLocationPage;
import org.protege.xmlcatalog.EntryVisitor;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.Entry;

public class LibraryPage
extends OntologyImportPage {
    private static final Logger logger = Logger.getLogger(LibraryPage.class);
    public static final String ID = "LibraryPage";
    private JList importList;
    private DefaultListModel importListModel;

    public LibraryPage(OWLEditorKit owlEditorKit) {
        super(ID, "Import from ontology library", owlEditorKit);
    }

    protected void createUI(JComponent parent) {
        this.setInstructions("The list below shows ontologies that are contained in the available ontology libaries.  Select the ones you want to import.");
        parent.setLayout(new BorderLayout());
        this.importListModel = new DefaultListModel();
        this.importList = new JList(this.importListModel);
        this.importList.setCellRenderer(new Renderer());
        this.calculatePossibleImports();
        this.importList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    LibraryPage.this.updateNextButtonEnabled();
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton addRepository = new JButton("Edit Repositories");
        addRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LibraryPage.this.handleEditRepositories();
            }
        });
        buttonPanel.add(addRepository);
        parent.add((Component)buttonPanel, "North");
        parent.add((Component)ComponentFactory.createScrollPane((JComponent)this.importList), "Center");
    }

    private void handleEditRepositories() {
        OntologyCatalogManager catalogManager = this.getOWLModelManager().getOntologyCatalogManager();
        File activeCatalogFile = OntologyCatalogManager.getCatalogFile(catalogManager.getActiveCatalog());
        try {
            OntologyLibraryPanel.showDialog(this.getOWLEditorKit(), activeCatalogFile);
            this.calculatePossibleImports();
        }
        catch (Exception e) {
            ProtegeApplication.getErrorLog().logError((Throwable)e);
        }
    }

    private void calculatePossibleImports() {
        GetImportsVisitor getter = new GetImportsVisitor();
        XMLCatalog library = this.getOWLEditorKit().getOWLModelManager().getOntologyCatalogManager().getActiveCatalog();
        if (library != null) {
            for (Entry e : library.getEntries()) {
                e.accept((EntryVisitor)getter);
            }
        }
        this.importListModel.clear();
        for (ImportInfo ii : getter.getImports()) {
            this.importListModel.addElement(ii);
        }
    }

    public void displayingPanel() {
        this.updateNextButtonEnabled();
        this.calculatePossibleImports();
    }

    public void aboutToHidePanel() {
        OntologyImportWizard wizard = this.getWizard();
        wizard.setImportsAreFinal(true);
        wizard.setCustomizeImports(false);
        wizard.clearImports();
        for (int index : this.importList.getSelectedIndices()) {
            wizard.addImport((ImportInfo)this.importListModel.getElementAt(index));
        }
        ((SelectImportLocationPage)this.getWizardModel().getPanel((Object)"SelectImportLocationPage")).setBackPanelDescriptor(ID);
        ((ImportConfirmationPage)this.getWizardModel().getPanel((Object)"ImportConfirmationPage")).setBackPanelDescriptor(ID);
        super.aboutToHidePanel();
    }

    public Object getBackPanelDescriptor() {
        return "ImportTypePage";
    }

    public Object getNextPanelDescriptor() {
        return "AnticipateOntologyIdPage";
    }

    private void updateNextButtonEnabled() {
        this.getWizard().setNextFinishButtonEnabled(this.importList.getSelectedIndex() != -1);
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ImportInfo) {
                ImportInfo ii = (ImportInfo)value;
                label.setText("<html>Import Declaration " + ii.getImportLocation() + "<p>from file " + ii.getPhysicalLocation() + "</p><br/></html>");
            }
            return label;
        }
    }
}

