/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class OntologyPreferences {
    public static final String DEFAULT_BASE = "http://www.semanticweb.org";
    public static final String PREFERENCES_KEY = "OntologyPreferences";
    public static final String BASE_URI_KEY = "BASE_URI";
    public static final String INC_YEAR_KEY = "INC_YEAR";
    public static final String INC_MONTH_KEY = "INC_MONTH";
    public static final String INC_DAY_KEY = "INC_DAY";
    public static final String INC_DOCUMENT_COUNTER = "INC_DOCUMENT_COUNTER";
    public static final String DOCUMENT_COUNTER = "DOCUMENT_COUNTER";
    private static OntologyPreferences instance;
    public static final String SYSTEM_USER_NAME_PROPERTY = "user.name";
    public static final int DOCUMENT_COUNTER_START = 1;
    private URI baseURI;
    private boolean includeYear = false;
    private boolean includeMonth = false;
    private boolean includeDay = false;
    private boolean useCounter = true;

    private OntologyPreferences() {
        StringBuilder sb = new StringBuilder();
        sb.append(DEFAULT_BASE);
        String userName = this.getNormalisedUserName();
        if (!userName.isEmpty()) {
            sb.append("/");
            sb.append(userName);
        }
        sb.append("/ontologies");
        this.baseURI = URI.create(sb.toString());
    }

    private String getNormalisedUserName() {
        String rawUserName = System.getProperty(SYSTEM_USER_NAME_PROPERTY);
        if (rawUserName == null) {
            return "";
        }
        String lowerCaseUserName = rawUserName.toLowerCase();
        String withoutSpaces = lowerCaseUserName.replaceAll("\\s", "");
        try {
            URI uri = new URI(withoutSpaces);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            Logger.getLogger(OntologyPreferences.class).warn((Object)("Could not encode user name for ontology IRI: " + e.getMessage()));
            return "";
        }
    }

    public static synchronized OntologyPreferences getInstance() {
        if (instance == null) {
            instance = new OntologyPreferences();
            instance.restore();
        }
        return instance;
    }

    private void restore() {
        Preferences p = this.getPreferences();
        this.baseURI = URI.create(p.getString(BASE_URI_KEY, this.baseURI.toString()));
        this.includeYear = p.getBoolean(INC_YEAR_KEY, true);
        this.includeMonth = p.getBoolean(INC_MONTH_KEY, true);
        this.includeDay = p.getBoolean(INC_DAY_KEY, false);
        this.useCounter = p.getBoolean(INC_DOCUMENT_COUNTER, true);
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
        this.save();
    }

    public boolean isIncludeYear() {
        return this.includeYear;
    }

    public void setIncludeYear(boolean includeYear) {
        this.includeYear = includeYear;
        this.save();
    }

    public boolean isIncludeMonth() {
        return this.includeMonth;
    }

    public void setIncludeMonth(boolean includeMonth) {
        this.includeMonth = includeMonth;
        this.save();
    }

    public boolean isIncludeDay() {
        return this.includeDay;
    }

    public void setIncludeDay(boolean includeDay) {
        this.includeDay = includeDay;
        this.save();
    }

    private void save() {
        Preferences p = this.getPreferences();
        p.putString(BASE_URI_KEY, this.baseURI.toString());
        p.putBoolean(INC_YEAR_KEY, this.includeYear);
        p.putBoolean(INC_MONTH_KEY, this.includeMonth);
        p.putBoolean(INC_DAY_KEY, this.includeDay);
    }

    private Preferences getPreferences() {
        return PreferencesManager.getInstance().getApplicationPreferences(PREFERENCES_KEY);
    }

    public int getCounter() {
        return this.getPreferences().getInt(DOCUMENT_COUNTER, 1);
    }

    public void incrementCounter() {
        Preferences preferences = this.getPreferences();
        int counter = preferences.getInt(DOCUMENT_COUNTER, 1);
        preferences.putInt(DOCUMENT_COUNTER, ++counter);
        this.save();
    }

    public void resetDocumentCounter() {
        this.getPreferences().putInt(DOCUMENT_COUNTER, 1);
        this.save();
    }

    public URI generateNextURI() {
        this.incrementCounter();
        return this.generateURI();
    }

    public URI generateURI() {
        String uriString = this.baseURI.toString();
        if (!uriString.endsWith("/")) {
            uriString = uriString + "/";
        }
        if (this.includeYear) {
            uriString = uriString + Calendar.getInstance().get(1) + "/";
            if (this.includeMonth) {
                uriString = uriString + Calendar.getInstance().get(2) + "/";
                if (this.includeDay) {
                    uriString = uriString + Calendar.getInstance().get(5) + "/";
                }
            }
        }
        String documentName = "untitled-ontology-" + this.getCounter();
        uriString = uriString + documentName;
        return URI.create(uriString);
    }
}

