/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.SetOntologyID;

public class ActiveOntologyView
extends AbstractOWLViewComponent {
    private static final Logger logger = Logger.getLogger(ActiveOntologyView.class);
    private JComboBox ontologiesList;
    private OWLModelManagerListener owlModelManagerListener = new OWLModelManagerListener(){

        @Override
        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED)) {
                ActiveOntologyView.this.updateList();
            }
        }
    };
    private final OWLOntologyChangeListener ontologyChangedListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> owlOntologyChanges) throws OWLException {
            ActiveOntologyView.this.handleOntologyChanges(owlOntologyChanges);
        }
    };

    private void updateList() {
        this.ontologiesList.setSelectedItem(this.getOWLModelManager().getActiveOntology());
        this.ontologiesList.setRenderer(this.ontologiesList.getRenderer());
    }

    @Override
    public void disposeOWLView() {
        this.getOWLModelManager().removeListener(this.owlModelManagerListener);
    }

    @Override
    public void initialiseOWLView() throws Exception {
        this.setLayout(new BorderLayout());
        this.ontologiesList = new JComboBox();
        this.ontologiesList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLOntology ont = (OWLOntology)ActiveOntologyView.this.ontologiesList.getSelectedItem();
                if (ont != null) {
                    ActiveOntologyView.this.getOWLModelManager().setActiveOntology(ont);
                }
            }
        });
        this.add(this.ontologiesList);
        this.getOWLModelManager().addListener(this.owlModelManagerListener);
        this.getOWLModelManager().addOntologyChangeListener(this.ontologyChangedListener);
        this.rebuildList();
    }

    private void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            System.out.println("UPDATE");
            if (!(oWLOntologyChange instanceof SetOntologyID)) continue;
            this.updateList();
            break;
        }
    }

    private void rebuildList() {
        try {
            this.ontologiesList.setModel(new DefaultComboBoxModel<Object>(this.getOWLModelManager().getOntologies().toArray()));
            this.updateList();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

