/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.navigation;

import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.selection.OWLSelectionHistoryManager;

public class OWLEntityNavigationMediator {
    private OWLEditorKit owlEditorKit;
    private Action backAction;
    private Action forwardAction;
    private ChangeListener listener;

    public OWLEntityNavigationMediator(OWLEditorKit owlEditorKit, Action backAction, Action forwardAction) {
        this.owlEditorKit = owlEditorKit;
        this.backAction = backAction;
        this.forwardAction = forwardAction;
        this.listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OWLEntityNavigationMediator.this.updateActionState();
            }
        };
        owlEditorKit.getWorkspace().getOWLSelectionHistoryManager().addChangeListener(this.listener);
        this.updateActionState();
    }

    public void dispose() {
        this.owlEditorKit.getWorkspace().getOWLSelectionHistoryManager().removeChangeListener(this.listener);
    }

    private void updateActionState() {
        OWLSelectionHistoryManager historyManager = this.owlEditorKit.getWorkspace().getOWLSelectionHistoryManager();
        this.backAction.setEnabled(historyManager.canGoBack());
        this.forwardAction.setEnabled(historyManager.canGoForward());
    }
}

