/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.library.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.model.repository.MasterOntologyIDExtractor;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.library.NewEntryPanel;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.XmlBaseContext;
import org.protege.xmlcatalog.entry.UriEntry;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class UriEntryPanel
extends NewEntryPanel {
    private static final long serialVersionUID = -6222499916124012217L;
    public static Logger LOGGER = Logger.getLogger(UriEntryPanel.class);
    private XMLCatalog catalog;
    private JTextField physicalLocationField;
    private JComboBox importDeclarationComboBox;

    public UriEntryPanel(XMLCatalog catalog) {
        this.setLayout(new BorderLayout());
        this.catalog = catalog;
        this.add((Component)this.createCenterPanel(), "Center");
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel physicalLocationPanel = new JPanel();
        physicalLocationPanel.setLayout(new FlowLayout());
        physicalLocationPanel.add(new JLabel("Physical Location: "));
        this.physicalLocationField = new JTextField();
        this.physicalLocationField.setPreferredSize(new JTextField("/home/tredmond/Shared/ontologies/simple/pizza-good.owl").getPreferredSize());
        physicalLocationPanel.add(this.physicalLocationField);
        JButton browse = new JButton("Browse");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = UIUtil.openFile((Component)UriEntryPanel.this, (String)"Choose OWL source", (String)"OWL File", UIHelper.OWL_EXTENSIONS);
                if (f != null) {
                    UriEntryPanel.this.physicalLocationField.setText(f.getPath());
                    UriEntryPanel.this.regenerateImportSuggestions();
                }
            }
        });
        physicalLocationPanel.add(browse);
        panel.add(physicalLocationPanel);
        JButton generate = new JButton("Generate Import Suggestions");
        generate.setAlignmentX(0.5f);
        generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UriEntryPanel.this.regenerateImportSuggestions();
            }
        });
        panel.add(generate);
        JPanel importDeclarationPanel = new JPanel();
        importDeclarationPanel.setLayout(new FlowLayout());
        importDeclarationPanel.add(new JLabel("Import Declaration: "));
        this.importDeclarationComboBox = new JComboBox();
        this.importDeclarationComboBox.setEditable(true);
        this.importDeclarationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UriEntryPanel.this.fireListeners();
            }
        });
        importDeclarationPanel.add(this.importDeclarationComboBox);
        panel.add(importDeclarationPanel);
        return panel;
    }

    private void regenerateImportSuggestions() {
        this.importDeclarationComboBox.removeAllItems();
        IRI preferred = null;
        URI u = this.getPhysicalLocation();
        if (u != null) {
            TreeSet<IRI> locations = new TreeSet<IRI>();
            if (!"file".equals(u.getScheme())) {
                preferred = IRI.create((URI)u);
                locations.add(preferred);
            }
            MasterOntologyIDExtractor extractor = new MasterOntologyIDExtractor();
            extractor.setPhysicalAddress(u);
            OWLOntologyID id = extractor.getOntologyId();
            if (!id.isAnonymous()) {
                preferred = id.getOntologyIRI();
                locations.add(preferred);
                if (id.getVersionIRI() != null) {
                    preferred = id.getVersionIRI();
                    locations.add(preferred);
                }
            }
            for (IRI location : locations) {
                this.importDeclarationComboBox.addItem(location);
            }
            if (preferred != null) {
                this.importDeclarationComboBox.setSelectedItem(preferred);
            }
            this.fireListeners();
            this.repaint();
        }
    }

    private URI getPhysicalLocation() {
        String text = this.physicalLocationField.getText();
        if (text == null) {
            return null;
        }
        try {
            if (new File(text).exists()) {
                return new File(text).toURI();
            }
            return new URI(text);
        }
        catch (URISyntaxException murle) {
            LOGGER.warn((Object)("Could not parse url " + text));
            return null;
        }
    }

    public UriEntry getEntry() {
        URI physicalLocation = this.getPhysicalLocation();
        if (physicalLocation == null || this.importDeclarationComboBox.getSelectedItem() == null) {
            return null;
        }
        String importDeclarationString = null;
        Object importDeclarationObject = this.importDeclarationComboBox.getSelectedItem();
        if (importDeclarationObject instanceof String) {
            importDeclarationString = (String)importDeclarationObject;
        } else if (importDeclarationObject instanceof IRI) {
            importDeclarationString = ((IRI)importDeclarationObject).toString();
        }
        if (importDeclarationString == null) {
            return null;
        }
        physicalLocation = CatalogUtilities.relativize((URI)physicalLocation, (XmlBaseContext)this.catalog);
        return new UriEntry("User Edited Redirect", (XmlBaseContext)this.catalog, importDeclarationString, physicalLocation, null);
    }
}

