/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.library.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.model.library.folder.FolderGroupManager;
import org.protege.editor.owl.ui.library.NewEntryPanel;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.XmlBaseContext;
import org.protege.xmlcatalog.entry.GroupEntry;

public class FolderGroupPanel
extends NewEntryPanel {
    private static final long serialVersionUID = 3602861945631171635L;
    private XMLCatalog catalog;
    private JTextField physicalLocationField;
    private JCheckBox recursive;

    public FolderGroupPanel(XMLCatalog catalog) {
        this.setLayout(new BorderLayout());
        this.catalog = catalog;
        this.add((Component)this.createCenterComponent(), "Center");
    }

    private JComponent createCenterComponent() {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        JPanel physicalLocationPanel = new JPanel();
        physicalLocationPanel.setLayout(new FlowLayout());
        physicalLocationPanel.add(new JLabel("Directory: "));
        this.physicalLocationField = new JTextField();
        this.physicalLocationField.setPreferredSize(new JTextField("/home/tredmond/Shared/ontologies/simple/pizza-good.owl").getPreferredSize());
        this.physicalLocationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderGroupPanel.this.fireListeners();
            }
        });
        physicalLocationPanel.add(this.physicalLocationField);
        JButton browse = new JButton("Browse");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = UIUtil.chooseFolder((Component)FolderGroupPanel.this, (String)"Folder for Ontology Repository");
                if (f != null) {
                    FolderGroupPanel.this.physicalLocationField.setText(f.getPath());
                    FolderGroupPanel.this.fireListeners();
                }
            }
        });
        physicalLocationPanel.add(browse);
        centerPanel.add(physicalLocationPanel);
        this.recursive = new JCheckBox("Recursively search subdirectories");
        this.recursive.setAlignmentX(0.5f);
        centerPanel.add(this.recursive);
        centerPanel.add(Box.createVerticalGlue());
        return centerPanel;
    }

    public GroupEntry getEntry() {
        String text = this.physicalLocationField.getText();
        if (text == null || text.length() == 0) {
            return null;
        }
        File dir = new File(text);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        try {
            URI folderUri = CatalogUtilities.relativize((URI)new File(this.physicalLocationField.getText()).toURI(), (XmlBaseContext)this.catalog);
            return FolderGroupManager.createGroupEntry(folderUri, this.recursive.isSelected(), true, (XmlBaseContext)this.catalog);
        }
        catch (IOException ioe) {
            ProtegeApplication.getErrorLog().logError((Throwable)ioe);
            return null;
        }
    }
}

